/*
 * Decompiled with CFR 0.152.
 */
package io.servicecomb.core.definition.loader;

import io.servicecomb.core.definition.MicroserviceMeta;
import io.servicecomb.core.definition.MicroserviceMetaManager;
import io.servicecomb.core.definition.SchemaMeta;
import io.servicecomb.core.definition.SchemaUtils;
import io.servicecomb.core.handler.ConsumerHandlerManager;
import io.servicecomb.core.handler.ProducerHandlerManager;
import io.servicecomb.serviceregistry.RegistryUtils;
import io.servicecomb.serviceregistry.api.registry.BasePath;
import io.servicecomb.serviceregistry.api.registry.Microservice;
import io.swagger.models.Swagger;
import java.net.URL;
import java.util.List;
import javax.inject.Inject;
import org.apache.commons.io.FilenameUtils;
import org.apache.commons.io.IOUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.core.io.Resource;
import org.springframework.stereotype.Component;

@Component
public class SchemaLoader {
    private static final Logger LOGGER = LoggerFactory.getLogger(SchemaLoader.class);
    @Inject
    protected MicroserviceMetaManager microserviceMetaManager;

    public void setMicroserviceMetaManager(MicroserviceMetaManager microserviceMetaManager) {
        this.microserviceMetaManager = microserviceMetaManager;
    }

    public SchemaMeta registerSchema(String microserviceName, Resource resource) {
        try {
            String schemaId = FilenameUtils.getBaseName((String)resource.getFilename());
            String swaggerContent = IOUtils.toString((URL)resource.getURL());
            SchemaMeta schemaMeta = this.registerSchema(microserviceName, schemaId, swaggerContent);
            return schemaMeta;
        }
        catch (Throwable e) {
            throw new Error(e);
        }
    }

    public SchemaMeta registerSchema(String microserviceName, String schemaId, String swaggerContent) {
        Swagger swagger = SchemaUtils.parseSwagger(swaggerContent);
        if (swagger == null) {
            throw new Error(String.format("Parse the swagger for %s:%s failed", microserviceName, schemaId));
        }
        return this.registerSchema(microserviceName, schemaId, swagger);
    }

    public SchemaMeta registerSchema(String microserviceName, String schemaId, Swagger swagger) {
        MicroserviceMeta microserviceMeta = this.microserviceMetaManager.getOrCreateMicroserviceMeta(microserviceName);
        return this.registerSchema(microserviceMeta, schemaId, swagger);
    }

    public SchemaMeta registerSchema(MicroserviceMeta microserviceMeta, String schemaId, Swagger swagger) {
        String microserviceName = microserviceMeta.getName();
        LOGGER.info("register schema {}/{}/{}", new Object[]{microserviceMeta.getAppId(), microserviceName, schemaId});
        SchemaMeta schemaMeta = new SchemaMeta(swagger, microserviceMeta, schemaId);
        List producerHandlerChain = (List)ProducerHandlerManager.INSTANCE.getOrCreate(microserviceName);
        schemaMeta.setProviderHandlerChain(producerHandlerChain);
        List consumerHandlerChain = (List)ConsumerHandlerManager.INSTANCE.getOrCreate(microserviceName);
        schemaMeta.setConsumerHandlerChain(consumerHandlerChain);
        microserviceMeta.regSchemaMeta(schemaMeta);
        this.putSelfBasePathIfAbsent(microserviceName, swagger.getBasePath());
        return schemaMeta;
    }

    public void putSelfBasePathIfAbsent(String microserviceName, String basePath) {
        if (basePath == null || basePath.length() == 0) {
            return;
        }
        Microservice microservice = RegistryUtils.getMicroservice();
        if (!microservice.getServiceName().equals(microserviceName)) {
            return;
        }
        List paths = microservice.getPaths();
        for (BasePath path : paths) {
            if (!path.getPath().equals(basePath)) continue;
            return;
        }
        BasePath basePathObj = new BasePath();
        basePathObj.setPath(basePath);
        paths.add(basePathObj);
    }
}

