/*
 * Decompiled with CFR 0.152.
 */
package io.servicecomb.core.definition.loader;

import io.servicecomb.core.definition.MicroserviceMeta;
import io.servicecomb.core.definition.MicroserviceMetaManager;
import io.servicecomb.core.definition.SchemaMeta;
import io.servicecomb.core.definition.loader.SchemaListener;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import javax.inject.Inject;
import org.springframework.stereotype.Component;

@Component
public class SchemaListenerManager {
    @Inject
    private List<SchemaListener> schemaListenerList;
    @Inject
    private MicroserviceMetaManager microserviceMetaManager;

    public void setSchemaListenerList(List<SchemaListener> schemaListenerList) {
        this.schemaListenerList = schemaListenerList;
    }

    public void setMicroserviceMetaManager(MicroserviceMetaManager microserviceMetaManager) {
        this.microserviceMetaManager = microserviceMetaManager;
    }

    public void notifySchemaListener(MicroserviceMeta ... microserviceMetas) {
        ArrayList<SchemaMeta> schemaMetaList = new ArrayList<SchemaMeta>();
        for (MicroserviceMeta microserviceMeta : microserviceMetas) {
            schemaMetaList.addAll(microserviceMeta.getSchemaMetas());
        }
        this.notifySchemaListener(schemaMetaList.toArray(new SchemaMeta[schemaMetaList.size()]));
    }

    public void notifySchemaListener() {
        Collection microserviceMetas = this.microserviceMetaManager.values();
        this.notifySchemaListener(microserviceMetas.toArray(new MicroserviceMeta[microserviceMetas.size()]));
    }

    public void notifySchemaListener(SchemaMeta ... schemaMetas) {
        for (SchemaListener listener : this.schemaListenerList) {
            listener.onSchemaLoaded(schemaMetas);
        }
    }

    public void notifySchemaListener(List<SchemaMeta> schemaMetaList) {
        SchemaMeta[] schemaMetas = schemaMetaList.toArray(new SchemaMeta[schemaMetaList.size()]);
        this.notifySchemaListener(schemaMetas);
    }

    public SchemaMeta ensureFindSchemaMeta(String microserviceName, String schemaId) {
        MicroserviceMeta microserviceMeta = (MicroserviceMeta)this.microserviceMetaManager.ensureFindValue(microserviceName);
        return microserviceMeta.ensureFindSchemaMeta(schemaId);
    }

    public Collection<SchemaMeta> getAllSchemaMeta(String microserviceName) {
        MicroserviceMeta microserviceMeta = (MicroserviceMeta)this.microserviceMetaManager.ensureFindValue(microserviceName);
        return microserviceMeta.getSchemaMetas();
    }
}

