/*
 * Decompiled with CFR 0.152.
 */
package io.servicecomb.core.definition.loader;

import io.servicecomb.core.CseContext;
import io.servicecomb.core.definition.SchemaMeta;
import io.servicecomb.foundation.common.config.PaaSResourceUtils;
import io.servicecomb.serviceregistry.RegistryUtils;
import java.util.ArrayList;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.core.io.Resource;

public class DynamicSchemaLoader {
    private static final Logger LOGGER = LoggerFactory.getLogger(DynamicSchemaLoader.class);
    public static final DynamicSchemaLoader INSTANCE = new DynamicSchemaLoader();

    public void registerSchemas(String schemaLocation) {
        this.registerSchemas(RegistryUtils.getMicroservice().getServiceName(), schemaLocation);
    }

    public void registerSchemas(String microserviceName, String schemaLocation) {
        Resource[] resArr;
        LOGGER.info("dynamic register schemas for {} in {}", (Object)microserviceName, (Object)schemaLocation);
        ArrayList<SchemaMeta> schemaMetaList = new ArrayList<SchemaMeta>();
        for (Resource resource : resArr = PaaSResourceUtils.getResources((String)schemaLocation)) {
            SchemaMeta schemaMeta = CseContext.getInstance().getSchemaLoader().registerSchema(microserviceName, resource);
            schemaMetaList.add(schemaMeta);
        }
        CseContext.getInstance().getSchemaListenerManager().notifySchemaListener(schemaMetaList);
    }
}

