/*
 * Decompiled with CFR 0.152.
 */
package io.servicecomb.core.definition;

import io.servicecomb.core.definition.CommonService;
import io.servicecomb.core.definition.OperationMeta;
import io.servicecomb.core.definition.SchemaMeta;
import io.servicecomb.foundation.common.RegisterManager;
import io.servicecomb.serviceregistry.RegistryUtils;
import java.util.Collection;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;

public class MicroserviceMeta
extends CommonService<OperationMeta> {
    private String appId;
    private String shortName;
    private ClassLoader classLoader;
    private RegisterManager<String, SchemaMeta> idSchemaMetaMgr;
    private RegisterManager<Class<?>, SchemaMeta> intfSchemaMetaMgr;
    private Map<String, Object> extData = new ConcurrentHashMap<String, Object>();

    public MicroserviceMeta(String microserviceName) {
        this.classLoader = Thread.currentThread().getContextClassLoader();
        this.parseMicroserviceName(microserviceName);
        this.createOperationMgr("Operation meta mgr for microservice " + microserviceName);
        this.idSchemaMetaMgr = new RegisterManager("Schema meta id mgr for microservice " + microserviceName);
        this.intfSchemaMetaMgr = new RegisterManager("Schema meta interface mgr for microservice " + microserviceName);
    }

    public void regSchemaMeta(SchemaMeta schemaMeta) {
        this.idSchemaMetaMgr.register((Object)schemaMeta.getSchemaId(), (Object)schemaMeta);
        this.intfSchemaMetaMgr.register(schemaMeta.getSwaggerIntf(), (Object)schemaMeta);
        for (OperationMeta operationMeta : schemaMeta.getOperations()) {
            this.regOperation(operationMeta.getSchemaQualifiedName(), operationMeta);
        }
    }

    public SchemaMeta ensureFindSchemaMeta(String schemaId) {
        return (SchemaMeta)this.idSchemaMetaMgr.ensureFindValue((Object)schemaId);
    }

    public SchemaMeta findSchemaMeta(String schemaId) {
        return (SchemaMeta)this.idSchemaMetaMgr.findValue((Object)schemaId);
    }

    public SchemaMeta ensureFindSchemaMeta(Class<?> schemaIntf) {
        return (SchemaMeta)this.intfSchemaMetaMgr.ensureFindValue(schemaIntf);
    }

    public SchemaMeta findSchemaMeta(Class<?> schemaIntf) {
        return (SchemaMeta)this.intfSchemaMetaMgr.findValue(schemaIntf);
    }

    public Collection<SchemaMeta> getSchemaMetas() {
        return this.idSchemaMetaMgr.values();
    }

    public void putExtData(String key, Object data) {
        this.extData.put(key, data);
    }

    public <T> T getExtData(String key) {
        return (T)this.extData.get(key);
    }

    public String getAppId() {
        return this.appId;
    }

    public String getShortName() {
        return this.shortName;
    }

    public ClassLoader getClassLoader() {
        return this.classLoader;
    }

    protected void parseMicroserviceName(String microserviceName) {
        int idxAt = microserviceName.indexOf(":");
        if (idxAt == -1) {
            this.appId = RegistryUtils.getMicroservice().getAppId();
            this.shortName = this.name = microserviceName;
            return;
        }
        this.appId = microserviceName.substring(0, idxAt);
        this.name = microserviceName;
        this.shortName = microserviceName.substring(idxAt + 1);
    }
}

