/*
 * Decompiled with CFR 0.152.
 */
package io.servicecomb.core;

import io.servicecomb.core.BootListener;
import io.servicecomb.core.definition.loader.SchemaListenerManager;
import io.servicecomb.core.handler.HandlerConfigUtils;
import io.servicecomb.core.provider.consumer.ConsumerProviderManager;
import io.servicecomb.core.provider.producer.ProducerProviderManager;
import io.servicecomb.core.transport.TransportManager;
import io.servicecomb.foundation.common.utils.BeanUtils;
import io.servicecomb.foundation.common.utils.FortifyUtils;
import io.servicecomb.serviceregistry.RegistryUtils;
import java.util.Collection;
import javax.inject.Inject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationEvent;
import org.springframework.context.ApplicationListener;
import org.springframework.context.event.ContextClosedEvent;
import org.springframework.context.event.ContextRefreshedEvent;
import org.springframework.context.support.AbstractApplicationContext;

public class CseApplicationListener
implements ApplicationListener<ApplicationEvent> {
    private static final Logger LOGGER = LoggerFactory.getLogger(CseApplicationListener.class);
    private static boolean isInit = false;
    @Inject
    private ProducerProviderManager producerProviderManager;
    @Inject
    private ConsumerProviderManager consumerProviderManager;
    @Inject
    private TransportManager transportManager;
    @Inject
    private SchemaListenerManager schemaListenerManager;
    private Collection<BootListener> bootListenerList;

    protected void triggerEvent(BootListener.EventType eventType) {
        BootListener.BootEvent event = new BootListener.BootEvent();
        event.setEventType(eventType);
        for (BootListener listener : this.bootListenerList) {
            listener.onBootEvent(event);
        }
    }

    public void onApplicationEvent(ApplicationEvent event) {
        if (event instanceof ContextRefreshedEvent) {
            ApplicationContext applicationContext = ((ContextRefreshedEvent)event).getApplicationContext();
            if (!isInit) {
                try {
                    BeanUtils.setContext((ApplicationContext)applicationContext);
                    this.bootListenerList = applicationContext.getBeansOfType(BootListener.class).values();
                    this.triggerEvent(BootListener.EventType.BEFORE_HANDLER);
                    HandlerConfigUtils.init();
                    this.triggerEvent(BootListener.EventType.AFTER_HANDLER);
                    this.triggerEvent(BootListener.EventType.BEFORE_PRODUCER_PROVIDER);
                    this.producerProviderManager.init();
                    this.triggerEvent(BootListener.EventType.AFTER_PRODUCER_PROVIDER);
                    this.triggerEvent(BootListener.EventType.BEFORE_CONSUMER_PROVIDER);
                    this.consumerProviderManager.init();
                    this.triggerEvent(BootListener.EventType.AFTER_CONSUMER_PROVIDER);
                    this.triggerEvent(BootListener.EventType.BEFORE_TRANSPORT);
                    this.transportManager.init();
                    this.triggerEvent(BootListener.EventType.AFTER_TRANSPORT);
                    this.schemaListenerManager.notifySchemaListener();
                    this.triggerEvent(BootListener.EventType.BEFORE_REGISTRY);
                    RegistryUtils.init();
                    this.triggerEvent(BootListener.EventType.AFTER_REGISTRY);
                    if (applicationContext instanceof AbstractApplicationContext) {
                        ((AbstractApplicationContext)applicationContext).registerShutdownHook();
                    }
                    isInit = true;
                }
                catch (Exception e) {
                    LOGGER.error("cse init failed, {}", (Object)FortifyUtils.getErrorInfo((Throwable)e));
                }
            }
        } else if (event instanceof ContextClosedEvent) {
            LOGGER.warn("cse is closing now...");
            RegistryUtils.destory();
            isInit = false;
        }
    }
}

