/*
 * Decompiled with CFR 0.152.
 */
package io.servicecomb.loadbalance.filter;

import com.netflix.loadbalancer.Server;
import io.servicecomb.loadbalance.CseServer;
import io.servicecomb.loadbalance.ServerListFilterExt;
import io.servicecomb.serviceregistry.RegistryUtils;
import io.servicecomb.serviceregistry.api.registry.MicroserviceInstance;
import java.util.ArrayList;
import java.util.List;

public class ZoneAwareServerListFilterExt
implements ServerListFilterExt {
    public List<Server> getFilteredListOfServers(List<Server> list) {
        CseServer cseServer;
        List<Server> result = new ArrayList<Server>();
        MicroserviceInstance myself = RegistryUtils.getMicroserviceInstance();
        boolean find = false;
        for (Server server : list) {
            cseServer = (CseServer)server;
            if (!this.regionAndAZMatch(myself, cseServer.getInstance())) continue;
            result.add(cseServer);
            find = true;
        }
        if (!find) {
            for (Server server : list) {
                cseServer = (CseServer)server;
                if (!this.regionMatch(myself, cseServer.getInstance())) continue;
                result.add(cseServer);
                find = true;
            }
        }
        if (!find) {
            result = list;
        }
        return result;
    }

    private boolean regionAndAZMatch(MicroserviceInstance myself, MicroserviceInstance target) {
        if (myself.getDataCenterInfo() != null && target.getDataCenterInfo() != null) {
            return myself.getDataCenterInfo().getRegion().equals(target.getDataCenterInfo().getRegion()) && myself.getDataCenterInfo().getAvailableZone().equals(target.getDataCenterInfo().getAvailableZone());
        }
        return false;
    }

    private boolean regionMatch(MicroserviceInstance myself, MicroserviceInstance target) {
        if (myself.getDataCenterInfo() != null && target.getDataCenterInfo() != null) {
            return myself.getDataCenterInfo().getRegion().equals(target.getDataCenterInfo().getRegion());
        }
        return false;
    }
}

