/*
 * Decompiled with CFR 0.152.
 */
package io.servicecomb.loadbalance;

import com.netflix.loadbalancer.AbstractLoadBalancer;
import com.netflix.loadbalancer.ILoadBalancer;
import com.netflix.loadbalancer.IRule;
import com.netflix.loadbalancer.LoadBalancerStats;
import com.netflix.loadbalancer.RoundRobinRule;
import com.netflix.loadbalancer.Server;
import com.netflix.loadbalancer.ServerStats;
import io.servicecomb.loadbalance.Configuration;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SessionStickinessRule
implements IRule {
    private static final Logger LOG = LoggerFactory.getLogger(SessionStickinessRule.class);
    private final Object lock = new Object();
    private ILoadBalancer lb;
    private IRule triggerRule = new RoundRobinRule();
    private volatile Server lastServer = null;
    private long lastAccessedTime = 0L;
    private volatile boolean errorThresholdMet = false;
    private static final int MILLI_COUNT_IN_SECOND = 1000;

    private Server chooseNextServer(Object key) {
        AbstractLoadBalancer lb = (AbstractLoadBalancer)this.getLoadBalancer();
        this.triggerRule.setLoadBalancer((ILoadBalancer)lb);
        this.lastServer = this.triggerRule.choose(key);
        this.lastAccessedTime = System.currentTimeMillis();
        return this.lastServer;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Server chooseInitialServer(Object key) {
        Object object = this.lock;
        synchronized (object) {
            if (this.lastServer == null) {
                this.chooseNextServer(key);
            }
        }
        return this.lastServer;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Server chooseServerWhenTimeout(Object key) {
        Object object = this.lock;
        synchronized (object) {
            if (this.isTimeOut()) {
                this.chooseNextServer(key);
            }
        }
        return this.lastServer;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Server chooseServerErrorThresholdMet(Object key) {
        Object object = this.lock;
        synchronized (object) {
            if (this.errorThresholdMet) {
                this.chooseNextServer(key);
                this.errorThresholdMet = false;
            }
        }
        return this.lastServer;
    }

    private boolean isTimeOut() {
        return Configuration.INSTANCE.getSessionTimeoutInSeconds() > 0 && System.currentTimeMillis() - this.lastAccessedTime > (long)Configuration.INSTANCE.getSessionTimeoutInSeconds() * 1000L;
    }

    private boolean isErrorThresholdMet() {
        AbstractLoadBalancer lb = (AbstractLoadBalancer)this.getLoadBalancer();
        LoadBalancerStats stats = lb.getLoadBalancerStats();
        if (stats != null && stats.getServerStats() != null && stats.getServerStats().size() > 0) {
            ServerStats serverStats = stats.getSingleServerStat(this.lastServer);
            int successiveFaildCount = serverStats.getSuccessiveConnectionFailureCount();
            if (Configuration.INSTANCE.getSuccessiveFailedTimes() > 0 && successiveFaildCount >= Configuration.INSTANCE.getSuccessiveFailedTimes()) {
                serverStats.clearSuccessiveConnectionFailureCount();
                return true;
            }
        }
        return false;
    }

    public Server choose(Object key) {
        if (this.lastServer == null) {
            return this.chooseInitialServer(key);
        }
        if (this.isTimeOut()) {
            LOG.warn("session timeout. choose another server.");
            return this.chooseServerWhenTimeout(key);
        }
        this.lastAccessedTime = System.currentTimeMillis();
        if (this.isErrorThresholdMet()) {
            LOG.warn("reached max error. choose another server.");
            this.errorThresholdMet = true;
            return this.chooseServerErrorThresholdMet(key);
        }
        return this.lastServer;
    }

    public void setLoadBalancer(ILoadBalancer lb) {
        this.lb = lb;
    }

    public ILoadBalancer getLoadBalancer() {
        return this.lb;
    }
}

