/*
 * Decompiled with CFR 0.152.
 */
package io.servicecomb.loadbalance;

import com.netflix.loadbalancer.Server;
import io.servicecomb.core.Endpoint;
import io.servicecomb.core.Transport;
import io.servicecomb.serviceregistry.api.registry.MicroserviceInstance;
import io.servicecomb.serviceregistry.cache.CacheEndpoint;
import java.util.concurrent.atomic.AtomicInteger;

public class CseServer
extends Server {
    private final Endpoint endpoint;
    private final MicroserviceInstance instance;
    private long lastVisitTime = System.currentTimeMillis();
    private AtomicInteger continuousFailureCount = new AtomicInteger(0);

    public long getLastVisitTime() {
        return this.lastVisitTime;
    }

    public void setLastVisitTime(long lastVisitTime) {
        this.lastVisitTime = lastVisitTime;
    }

    public CseServer(Transport transport, CacheEndpoint cacheEndpoint) {
        super(null);
        this.endpoint = new Endpoint(transport, cacheEndpoint.getEndpoint(), cacheEndpoint.getInstance());
        this.instance = cacheEndpoint.getInstance();
        this.setAlive(true);
        this.setReadyToServe(true);
    }

    public Endpoint getEndpoint() {
        return this.endpoint;
    }

    public MicroserviceInstance getInstance() {
        return this.instance;
    }

    public String toString() {
        return this.endpoint.getEndpoint();
    }

    public String getHost() {
        return this.endpoint.getEndpoint();
    }

    public void clearContinuousFailure() {
        this.continuousFailureCount.set(0);
    }

    public void incrementContinuousFailureCount() {
        if (this.continuousFailureCount.get() < Integer.MAX_VALUE) {
            this.continuousFailureCount.incrementAndGet();
        }
    }

    public int getCountinuousFailureCount() {
        return this.continuousFailureCount.get();
    }

    public boolean equals(Object o) {
        if (o instanceof CseServer) {
            return this.getHost().equals(((CseServer)((Object)o)).getHost());
        }
        return false;
    }

    public int hashCode() {
        return this.getHost().hashCode();
    }
}

