/*
 * Decompiled with CFR 0.152.
 */
package io.servicecomb.loadbalance;

import com.google.common.collect.Lists;
import com.netflix.loadbalancer.IRule;
import com.netflix.loadbalancer.RandomRule;
import com.netflix.loadbalancer.RoundRobinRule;
import com.netflix.loadbalancer.WeightedResponseTimeRule;
import io.servicecomb.loadbalance.ExtensionsFactory;
import io.servicecomb.loadbalance.SessionStickinessRule;
import java.util.Collection;
import org.springframework.stereotype.Component;

@Component
public class RuleNameExtentionsFactory
implements ExtensionsFactory {
    private static final Collection<String> ACCEPT_KEYS = Lists.newArrayList((Object[])new String[]{"strategy.name"});
    private static final String RULE_RoundRobin = "RoundRobin";
    private static final String RULE_Random = "Random";
    private static final String RULE_WeightedResponse = "WeightedResponse";
    private static final String RULE_SessionStickiness = "SessionStickiness";
    private static final Collection<String> ACCEPT_VALUES = Lists.newArrayList((Object[])new String[]{"RoundRobin", "Random", "WeightedResponse", "SessionStickiness"});

    @Override
    public boolean isSupport(String key, String value) {
        return ACCEPT_KEYS.contains(key) && ACCEPT_VALUES.contains(value);
    }

    @Override
    public IRule createLoadBalancerRule(String ruleName) {
        if (RULE_RoundRobin.equals(ruleName)) {
            return new RoundRobinRule();
        }
        if (RULE_Random.equals(ruleName)) {
            return new RandomRule();
        }
        if (RULE_WeightedResponse.equals(ruleName)) {
            return new WeightedResponseTimeRule();
        }
        if (RULE_SessionStickiness.equals(ruleName)) {
            return new SessionStickinessRule();
        }
        throw new IllegalStateException("unexpected code to reach here, value is " + ruleName);
    }
}

