/*
 * Decompiled with CFR 0.152.
 */
package io.servicecomb.loadbalance;

import com.netflix.loadbalancer.AbstractLoadBalancer;
import com.netflix.loadbalancer.ILoadBalancer;
import com.netflix.loadbalancer.IRule;
import com.netflix.loadbalancer.LoadBalancerStats;
import com.netflix.loadbalancer.Server;
import com.netflix.loadbalancer.ServerListFilter;
import io.servicecomb.core.Invocation;
import io.servicecomb.loadbalance.CseServerList;
import io.servicecomb.loadbalance.ServerListFilterExt;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;

public class LoadBalancer
extends AbstractLoadBalancer {
    private CseServerList serverList;
    private IRule rule;
    private LoadBalancerStats lbStats;
    private Map<String, ServerListFilterExt> filters;

    public LoadBalancer(CseServerList serverList, IRule rule) {
        this.serverList = serverList;
        this.rule = rule;
        this.rule.setLoadBalancer((ILoadBalancer)this);
        this.lbStats = new LoadBalancerStats(null);
        this.filters = new ConcurrentHashMap<String, ServerListFilterExt>();
    }

    public void addServers(List<Server> newServers) {
        throw new UnsupportedOperationException("Not implemented.");
    }

    public Server chooseServer(Object key) {
        return this.rule.choose(key);
    }

    public void markServerDown(Server server) {
        throw new UnsupportedOperationException("Not implemented.");
    }

    public List<Server> getServerList(boolean availableOnly) {
        return this.getAllServers();
    }

    public List<Server> getReachableServers() {
        return this.getAllServers();
    }

    public List<Server> getAllServers() {
        List servers = this.serverList.getInitialListOfServers();
        for (ServerListFilter serverListFilter : this.filters.values()) {
            servers = serverListFilter.getFilteredListOfServers(servers);
        }
        return servers;
    }

    public List<Server> getServerList(AbstractLoadBalancer.ServerGroup serverGroup) {
        throw new UnsupportedOperationException("Not implemented.");
    }

    public LoadBalancerStats getLoadBalancerStats() {
        return this.lbStats;
    }

    public void setInvocation(Invocation invocation) {
        for (ServerListFilterExt filter : this.filters.values()) {
            filter.setInvocation(invocation);
        }
    }

    public void putFilter(String name, ServerListFilterExt filter) {
        this.filters.put(name, filter);
    }

    public int getFilterSize() {
        return this.filters.size();
    }
}

