/*
 * Decompiled with CFR 0.152.
 */
package io.servicecomb.loadbalance;

import com.google.common.collect.Lists;
import com.netflix.client.DefaultLoadBalancerRetryHandler;
import com.netflix.client.RetryHandler;
import io.servicecomb.loadbalance.Configuration;
import io.servicecomb.loadbalance.ExtensionsFactory;
import java.util.Collection;
import org.springframework.stereotype.Component;

@Component
public class DefaultRetryExtensionsFactory
implements ExtensionsFactory {
    private static final Collection<String> ACCEPT_KEYS = Lists.newArrayList((Object[])new String[]{"retryHandler"});
    private static final String RETRY_DEFAULT = "default";
    private static final Collection<String> ACCEPT_VALUES = Lists.newArrayList((Object[])new String[]{"default"});

    @Override
    public boolean isSupport(String key, String value) {
        return ACCEPT_KEYS.contains(key) && ACCEPT_VALUES.contains(value);
    }

    @Override
    public RetryHandler createRetryHandler(String retryName, String microservice) {
        DefaultLoadBalancerRetryHandler handler = new DefaultLoadBalancerRetryHandler(Configuration.INSTANCE.getRetryOnSame(microservice), Configuration.INSTANCE.getRetryOnNext(microservice), true);
        return handler;
    }
}

