/*
 * Decompiled with CFR 0.152.
 */
package io.servicecomb.loadbalance.filter;

import com.netflix.loadbalancer.Server;
import io.servicecomb.loadbalance.Configuration;
import io.servicecomb.loadbalance.CseServer;
import io.servicecomb.loadbalance.filter.TransactionControlFilter;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;

public class SimpleTransactionControlFilter
extends TransactionControlFilter {
    public List<Server> getFilteredListOfServers(List<Server> servers) {
        ArrayList<Server> filteredServers = new ArrayList<Server>();
        Map<String, String> filterOptions = Configuration.INSTANCE.getFlowsplitFilterOptions(this.getInvocation().getMicroserviceName());
        for (Server server : servers) {
            if (!this.allowVisit((CseServer)server, filterOptions)) continue;
            filteredServers.add(server);
        }
        return filteredServers;
    }

    protected boolean allowVisit(CseServer server, Map<String, String> filterOptions) {
        Map propertiesMap = server.getInstance().getProperties();
        for (Map.Entry<String, String> entry : filterOptions.entrySet()) {
            if (entry.getValue().equals(propertiesMap.get(entry.getKey()))) continue;
            return false;
        }
        return true;
    }
}

