/*
 * Decompiled with CFR 0.152.
 */
package io.servicecomb.loadbalance.filter;

import com.netflix.loadbalancer.LoadBalancerStats;
import com.netflix.loadbalancer.Server;
import com.netflix.loadbalancer.ServerStats;
import io.servicecomb.core.Invocation;
import io.servicecomb.loadbalance.Configuration;
import io.servicecomb.loadbalance.CseServer;
import io.servicecomb.loadbalance.ServerListFilterExt;
import java.util.ArrayList;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class IsolationServerListFilter
implements ServerListFilterExt {
    private static final Logger LOGGER = LoggerFactory.getLogger(IsolationServerListFilter.class);
    private static final double PERCENT = 100.0;
    private String microserviceName;
    private int errorThresholdPercentage;
    private long singleTestTime;
    private long enableRequestThreshold;
    private Invocation invocation;
    private LoadBalancerStats stats;

    @Override
    public void setInvocation(Invocation invocation) {
        this.invocation = invocation;
    }

    public void setLoadBalancerStats(LoadBalancerStats stats) {
        this.stats = stats;
    }

    public LoadBalancerStats getLoadBalancerStats() {
        return this.stats;
    }

    public String getMicroserviceName() {
        return this.microserviceName;
    }

    public void setMicroserviceName(String microserviceName) {
        this.microserviceName = microserviceName;
    }

    public List<Server> getFilteredListOfServers(List<Server> servers) {
        if (!Configuration.INSTANCE.isIsolationFilterOpen(this.invocation.getMicroserviceName())) {
            return servers;
        }
        ArrayList<Server> filteredServers = new ArrayList<Server>();
        for (Server server : servers) {
            if (!this.allowVisit(server)) continue;
            filteredServers.add(server);
        }
        return filteredServers;
    }

    private void updateSettings() {
        this.errorThresholdPercentage = Configuration.INSTANCE.getErrorThresholdPercentage(this.microserviceName);
        this.singleTestTime = Configuration.INSTANCE.getSingleTestTime(this.microserviceName);
        this.enableRequestThreshold = Configuration.INSTANCE.getEnableRequestThreshold(this.microserviceName);
    }

    private boolean allowVisit(Server server) {
        this.updateSettings();
        ServerStats serverStats = this.stats.getSingleServerStat(server);
        long totalRequest = serverStats.getTotalRequestsCount();
        long failureRequest = serverStats.getSuccessiveConnectionFailureCount();
        if (totalRequest < this.enableRequestThreshold) {
            return true;
        }
        if ((double)failureRequest / (double)totalRequest * 100.0 < (double)this.errorThresholdPercentage) {
            return true;
        }
        if (System.currentTimeMillis() - ((CseServer)server).getLastVisitTime() > this.singleTestTime) {
            LOGGER.info("The Service {}'s instance {} has been break, will give a single test opportunity.", (Object)this.microserviceName, (Object)server);
            return true;
        }
        LOGGER.warn("The Service {}'s instance {} has been break!", (Object)this.microserviceName, (Object)server);
        return false;
    }
}

