/*
 * Decompiled with CFR 0.152.
 */
package io.servicecomb.loadbalance;

import com.netflix.client.DefaultLoadBalancerRetryHandler;
import com.netflix.client.RetryHandler;
import com.netflix.loadbalancer.ILoadBalancer;
import com.netflix.loadbalancer.IRule;
import com.netflix.loadbalancer.RoundRobinRule;
import com.netflix.loadbalancer.Server;
import com.netflix.loadbalancer.reactive.ExecutionContext;
import com.netflix.loadbalancer.reactive.ExecutionInfo;
import com.netflix.loadbalancer.reactive.ExecutionListener;
import com.netflix.loadbalancer.reactive.LoadBalancerCommand;
import com.netflix.loadbalancer.reactive.ServerOperation;
import io.servicecomb.core.Invocation;
import io.servicecomb.core.exception.ExceptionUtils;
import io.servicecomb.core.handler.impl.AbstractHandler;
import io.servicecomb.core.provider.consumer.SyncResponseExecutor;
import io.servicecomb.loadbalance.Configuration;
import io.servicecomb.loadbalance.CseServer;
import io.servicecomb.loadbalance.CseServerList;
import io.servicecomb.loadbalance.LoadBalancer;
import io.servicecomb.loadbalance.ServerListFilterExt;
import io.servicecomb.loadbalance.filter.IsolationServerListFilter;
import io.servicecomb.loadbalance.filter.TransactionControlFilter;
import io.servicecomb.swagger.invocation.AsyncResponse;
import io.servicecomb.swagger.invocation.Response;
import java.util.ArrayList;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.Executor;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import rx.Observable;

public class LoadbalanceHandler
extends AbstractHandler {
    private static final Logger LOGGER = LoggerFactory.getLogger(LoadbalanceHandler.class);
    private static final ExecutorService RETRY_POOL = Executors.newCachedThreadPool(new ThreadFactory(){
        private AtomicInteger count = new AtomicInteger(0);

        @Override
        public Thread newThread(Runnable r) {
            return new Thread(r, "retry-pool-thread-" + this.count.getAndIncrement());
        }
    });
    private volatile Map<String, LoadBalancer> loadBalancerMap = new ConcurrentHashMap<String, LoadBalancer>();
    private final Object lock = new Object();
    private String policy = null;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void handle(Invocation invocation, AsyncResponse asyncResp) throws Exception {
        String p = Configuration.INSTANCE.getPolicy(invocation.getMicroserviceName());
        if (this.policy != null && !this.policy.equals(p)) {
            Object object = this.lock;
            synchronized (object) {
                this.loadBalancerMap.clear();
            }
        }
        this.policy = p;
        String transportName = invocation.getConfigTransportName();
        LoadBalancer lb = this.loadBalancerMap.get(transportName);
        if (null == lb) {
            Object object = this.lock;
            synchronized (object) {
                lb = this.loadBalancerMap.get(transportName);
                if (null == lb) {
                    lb = this.createLoadBalancer(invocation.getAppId(), invocation.getMicroserviceName(), invocation.getMicroserviceVersionRule(), transportName);
                    this.loadBalancerMap.put(transportName, lb);
                }
            }
        }
        lb.setInvocation(invocation);
        LoadBalancer choosenLB = lb;
        if (!Configuration.INSTANCE.isRetryEnabled(invocation.getMicroserviceName())) {
            this.send(invocation, asyncResp, choosenLB);
        } else {
            this.sendWithRetry(invocation, asyncResp, choosenLB);
        }
    }

    protected void setIsolationFilter(LoadBalancer lb, String microserviceName) {
        String filterName = IsolationServerListFilter.class.getName();
        IsolationServerListFilter isolationListFilter = new IsolationServerListFilter();
        isolationListFilter.setMicroserviceName(microserviceName);
        isolationListFilter.setLoadBalancerStats(lb.getLoadBalancerStats());
        lb.putFilter(filterName, isolationListFilter);
    }

    protected void setTransactionControlFilter(LoadBalancer lb, String microserviceName) {
        String filterName = TransactionControlFilter.class.getName();
        String policyClsName = Configuration.INSTANCE.getFlowsplitFilterPolicy(microserviceName);
        if (policyClsName.isEmpty()) {
            return;
        }
        try {
            Class<?> policyCls = Class.forName(policyClsName);
            if (!TransactionControlFilter.class.isAssignableFrom(policyCls)) {
                String errMsg = String.format("Define instance filter %s in yaml, but not extends abstract class TransactionControlFilter.", policyClsName);
                LOGGER.error(errMsg);
                throw new Error(errMsg);
            }
            TransactionControlFilter transactionControlFilter = (TransactionControlFilter)policyCls.newInstance();
            transactionControlFilter.setLoadBalancerStats(lb.getLoadBalancerStats());
            lb.putFilter(filterName, transactionControlFilter);
        }
        catch (Throwable e) {
            String errMsg = "Fail to create instance of class: " + policyClsName;
            LOGGER.error(errMsg);
            throw new Error(errMsg, e);
        }
    }

    private void send(Invocation invocation, AsyncResponse asyncResp, LoadBalancer choosenLB) throws Exception {
        long time = System.currentTimeMillis();
        CseServer server = (CseServer)choosenLB.chooseServer(invocation);
        if (null == server) {
            asyncResp.consumerFail((Throwable)ExceptionUtils.lbAddressNotFound((String)invocation.getMicroserviceName(), (String)invocation.getMicroserviceVersionRule(), (String)invocation.getConfigTransportName()));
            return;
        }
        server.setLastVisitTime(time);
        choosenLB.getLoadBalancerStats().incrementNumRequests((Server)server);
        invocation.setEndpoint(server.getEndpoint());
        invocation.next(resp -> {
            choosenLB.getLoadBalancerStats().noteResponseTime((Server)server, (double)(System.currentTimeMillis() - time));
            if (resp.isFailed()) {
                choosenLB.getLoadBalancerStats().incrementSuccessiveConnectionFailureCount((Server)server);
            } else {
                choosenLB.getLoadBalancerStats().incrementActiveRequestsCount((Server)server);
            }
            asyncResp.handle(resp);
        });
    }

    private void sendWithRetry(final Invocation invocation, final AsyncResponse asyncResp, final LoadBalancer choosenLB) throws Exception {
        SyncResponseExecutor orginExecutor;
        final long time = System.currentTimeMillis();
        final int currentHandler = invocation.getHandlerIndex();
        if (invocation.getResponseExecutor() instanceof SyncResponseExecutor) {
            orginExecutor = (SyncResponseExecutor)invocation.getResponseExecutor();
            Executor newExecutor = new Executor(){

                @Override
                public void execute(Runnable command) {
                    RETRY_POOL.submit(command);
                }
            };
            invocation.setResponseExecutor(newExecutor);
        } else {
            orginExecutor = null;
            Object newExecutor = null;
        }
        ExecutionListener<Invocation, Response> listener = new ExecutionListener<Invocation, Response>(){

            public void onExecutionStart(ExecutionContext<Invocation> context) throws ExecutionListener.AbortExecutionException {
            }

            public void onStartWithServer(ExecutionContext<Invocation> context, ExecutionInfo info) throws ExecutionListener.AbortExecutionException {
            }

            public void onExceptionWithServer(ExecutionContext<Invocation> context, Throwable exception, ExecutionInfo info) {
                LOGGER.error("onExceptionWithServer msg {}; server {}", (Object)exception.getMessage(), (Object)((Invocation)context.getRequest()).getEndpoint());
            }

            public void onExecutionSuccess(ExecutionContext<Invocation> context, Response response, ExecutionInfo info) {
                if (orginExecutor != null) {
                    orginExecutor.execute(() -> asyncResp.complete(response));
                } else {
                    asyncResp.complete(response);
                }
            }

            public void onExecutionFailed(ExecutionContext<Invocation> context, Throwable finalException, ExecutionInfo info) {
                if (orginExecutor != null) {
                    orginExecutor.execute(() -> asyncResp.consumerFail(finalException));
                } else {
                    asyncResp.consumerFail(finalException);
                }
            }
        };
        ArrayList<3> listeners = new ArrayList<3>(0);
        listeners.add(listener);
        ExecutionContext context = new ExecutionContext((Object)invocation, null, null, null);
        LoadBalancerCommand command = LoadBalancerCommand.builder().withLoadBalancer((ILoadBalancer)choosenLB).withServerLocator((Object)invocation).withRetryHandler((RetryHandler)new DefaultLoadBalancerRetryHandler(Configuration.INSTANCE.getRetryOnSame(invocation.getMicroserviceName()), Configuration.INSTANCE.getRetryOnNext(invocation.getMicroserviceName()), true)).withListeners(listeners).withExecutionContext(context).build();
        Observable observable = command.submit((ServerOperation)new ServerOperation<Response>(){

            public Observable<Response> call(Server s) {
                return Observable.create(f -> {
                    try {
                        ((CseServer)s).setLastVisitTime(time);
                        choosenLB.getLoadBalancerStats().incrementNumRequests(s);
                        invocation.setHandlerIndex(currentHandler);
                        invocation.setEndpoint(((CseServer)s).getEndpoint());
                        invocation.next(resp -> {
                            if (resp.isFailed()) {
                                LOGGER.error("service call error, msg is {}, server is {} ", (Object)((Throwable)resp.getResult()).getMessage(), (Object)s);
                                choosenLB.getLoadBalancerStats().incrementSuccessiveConnectionFailureCount(s);
                                f.onError((Throwable)resp.getResult());
                            } else {
                                choosenLB.getLoadBalancerStats().incrementActiveRequestsCount(s);
                                choosenLB.getLoadBalancerStats().noteResponseTime(s, (double)(System.currentTimeMillis() - time));
                                f.onNext((Object)resp);
                                f.onCompleted();
                            }
                        });
                    }
                    catch (Exception e) {
                        LOGGER.error("execution error, msg is " + e.getMessage());
                        f.onError((Throwable)e);
                    }
                });
            }
        });
        observable.subscribe(response -> {}, error -> {}, () -> {});
    }

    private LoadBalancer createLoadBalancer(String appId, String microserviceName, String microserviceVersionRule, String transportName) {
        IRule rule;
        try {
            rule = (IRule)Class.forName(this.policy, true, Thread.currentThread().getContextClassLoader()).newInstance();
            LOGGER.info("Using loadbalance rule [{}] for service [{},{}].", new Object[]{this.policy, microserviceName, microserviceVersionRule});
        }
        catch (ClassNotFoundException | IllegalAccessException | InstantiationException e) {
            LOGGER.warn("Loadbalance rule [{}] is incorrect, using default RoundRobinRule.", (Object)this.policy);
            rule = new RoundRobinRule();
        }
        CseServerList serverList = new CseServerList(appId, microserviceName, microserviceVersionRule, transportName);
        LoadBalancer lb = new LoadBalancer(serverList, rule);
        this.loadServerListFilters(lb);
        this.setIsolationFilter(lb, microserviceName);
        this.setTransactionControlFilter(lb, microserviceName);
        return lb;
    }

    private void loadServerListFilters(LoadBalancer lb) {
        String filterNames = Configuration.getStringProperty(null, "cse.loadbalance.serverListFilters");
        if (!StringUtils.isEmpty((CharSequence)filterNames)) {
            for (String filter : filterNames.split(",")) {
                this.loadFilter(filter, lb);
            }
        }
    }

    private void loadFilter(String filter, LoadBalancer lb) {
        String className = Configuration.getStringProperty(null, String.format("cse.loadbalance.serverListFilter.%s.className", filter));
        if (!StringUtils.isEmpty((CharSequence)className)) {
            try {
                Class<?> filterClass = Class.forName(className, true, Thread.currentThread().getContextClassLoader());
                if (ServerListFilterExt.class.isAssignableFrom(filterClass)) {
                    ServerListFilterExt ext = (ServerListFilterExt)filterClass.newInstance();
                    ext.setName(filter);
                    ext.setLoadBalancer(lb);
                    lb.putFilter(filter, ext);
                }
            }
            catch (ClassNotFoundException | IllegalAccessException | InstantiationException e) {
                LOGGER.warn("Unable to load filter class: " + className);
            }
        }
    }
}

