/*
 * Decompiled with CFR 0.152.
 */
package io.servicecomb.loadbalance;

import com.netflix.config.DynamicPropertyFactory;
import io.servicecomb.serviceregistry.config.ConfigurePropertyUtils;
import java.util.Map;

public final class Configuration {
    public static final String PROP_ROOT = "cse.loadbalance.";
    public static final String PROP_POLICY = "NFLoadBalancerRuleClassName";
    public static final String PROP_POLICY_ROUNDROBIN = "com.netflix.loadbalancer.RoundRobinRule";
    public static final String PROP_ROOT_20 = "ribbon.";
    public static final String PROP_RETRY_ENABLED = "retryEnabled";
    public static final String PROP_RETRY_ONNEXT = "retryOnNext";
    public static final String PROP_RETRY_ONSAME = "retryOnSame";
    public static final String SESSION_TIMEOUT_IN_SECONDS = "SessionStickinessRule.sessionTimeoutInSeconds";
    public static final String SUCCESSIVE_FAILED_TIMES = "SessionStickinessRule.successiveFailedTimes";
    public static final String SERVER_LIST_FILTERS = "cse.loadbalance.serverListFilters";
    public static final String SERVER_LIST_FILTER_CLASS_HOLDER = "cse.loadbalance.serverListFilter.%s.className";
    public static final String SERVER_LIST_FILTER_PROPERTY_HOLDER = "cse.loadbalance.serverListFilter.%s.%s";
    private static final double PERCENT = 100.0;
    public static final String FILTER_ISOLATION = "isolation.";
    public static final String FILTER_OPEN = "enabled";
    public static final String FILTER_ERROR_PERCENTAGE = "errorThresholdPercentage";
    public static final String FILTER_ENABLE_REQUEST = "enableRequestThreshold";
    public static final String FILTER_SINGLE_TEST = "singleTestTime";
    public static final String TRANSACTIONCONTROL_OPTIONS_PREFIX_PATTERN = "cse.loadbalance.%s.transactionControl.options";
    public static final String TRANSACTIONCONTROL_POLICY_KEY_PATTERN = "cse.loadbalance.%s.transactionControl.policy";
    public static final Configuration INSTANCE = new Configuration();

    private Configuration() {
    }

    public String getPolicy(String microservice) {
        return Configuration.getStringProperty(PROP_POLICY_ROUNDROBIN, PROP_ROOT + microservice + "." + PROP_POLICY, PROP_ROOT_20 + microservice + "." + PROP_POLICY, "cse.loadbalance.NFLoadBalancerRuleClassName", "ribbon.NFLoadBalancerRuleClassName");
    }

    public int getSessionTimeoutInSeconds() {
        int defaultValue = 30;
        String p = Configuration.getStringProperty("30", "cse.loadbalance.SessionStickinessRule.sessionTimeoutInSeconds");
        try {
            return Integer.parseInt(p);
        }
        catch (NumberFormatException e) {
            return 30;
        }
    }

    public int getSuccessiveFailedTimes() {
        int defaultValue = 5;
        String p = Configuration.getStringProperty("5", "cse.loadbalance.SessionStickinessRule.successiveFailedTimes");
        try {
            return Integer.parseInt(p);
        }
        catch (NumberFormatException e) {
            return 5;
        }
    }

    public boolean isRetryEnabled(String microservice) {
        String p = Configuration.getStringProperty("false", PROP_ROOT + microservice + "." + PROP_RETRY_ENABLED, "cse.loadbalance.retryEnabled");
        return Boolean.parseBoolean(p);
    }

    public int getRetryOnNext(String microservice) {
        boolean defaultValue = false;
        String p = Configuration.getStringProperty("0", PROP_ROOT + microservice + "." + PROP_RETRY_ONNEXT, "cse.loadbalance.retryOnNext");
        try {
            int result = Integer.parseInt(p);
            if (result > 0) {
                return result;
            }
            return 0;
        }
        catch (NumberFormatException e) {
            return 0;
        }
    }

    public int getRetryOnSame(String microservice) {
        boolean defaultValue = false;
        String p = Configuration.getStringProperty("0", PROP_ROOT + microservice + "." + PROP_RETRY_ONSAME, "cse.loadbalance.retryOnSame");
        try {
            int result = Integer.parseInt(p);
            if (result > 0) {
                return result;
            }
            return 0;
        }
        catch (NumberFormatException e) {
            return 0;
        }
    }

    public boolean isIsolationFilterOpen(String microservice) {
        String p = Configuration.getStringProperty("false", PROP_ROOT + microservice + "." + FILTER_ISOLATION + FILTER_OPEN, "cse.loadbalance.isolation.enabled");
        return Boolean.parseBoolean(p);
    }

    public int getErrorThresholdPercentage(String microservice) {
        int defaultValue = 20;
        String p = Configuration.getStringProperty("20", PROP_ROOT + microservice + "." + FILTER_ISOLATION + FILTER_ERROR_PERCENTAGE, "cse.loadbalance.isolation.errorThresholdPercentage");
        try {
            int result = Integer.parseInt(p);
            if ((double)result <= 100.0 && result > 0) {
                return result;
            }
            return 20;
        }
        catch (NumberFormatException e) {
            return 20;
        }
    }

    public int getEnableRequestThreshold(String microservice) {
        int defaultValue = 20;
        String p = Configuration.getStringProperty("20", PROP_ROOT + microservice + "." + FILTER_ISOLATION + FILTER_ENABLE_REQUEST, "cse.loadbalance.isolation.enableRequestThreshold");
        try {
            int result = Integer.parseInt(p);
            if (result > 0) {
                return result;
            }
            return 20;
        }
        catch (NumberFormatException e) {
            return 20;
        }
    }

    public int getSingleTestTime(String microservice) {
        int defaultValue = 10000;
        String p = Configuration.getStringProperty("10000", PROP_ROOT + microservice + "." + FILTER_ISOLATION + FILTER_SINGLE_TEST, "cse.loadbalance.isolation.singleTestTime");
        try {
            int result = Integer.parseInt(p);
            if (result > 0) {
                return result;
            }
            return 10000;
        }
        catch (NumberFormatException e) {
            return 10000;
        }
    }

    public String getFlowsplitFilterPolicy(String microservice) {
        return Configuration.getStringProperty("", String.format(TRANSACTIONCONTROL_POLICY_KEY_PATTERN, microservice));
    }

    public Map<String, String> getFlowsplitFilterOptions(String microservice) {
        String keyPrefix = String.format(TRANSACTIONCONTROL_OPTIONS_PREFIX_PATTERN, microservice);
        return ConfigurePropertyUtils.getPropertiesWithPrefix((String)keyPrefix);
    }

    public static String getStringProperty(String defaultValue, String ... keys) {
        String property = null;
        for (String key : keys) {
            property = DynamicPropertyFactory.getInstance().getStringProperty(key, null).get();
            if (property != null) break;
        }
        if (property != null) {
            return property;
        }
        return defaultValue;
    }
}

