/*
 * Decompiled with CFR 0.152.
 */
package io.servicecomb.loadbalance;

import com.netflix.loadbalancer.AbstractLoadBalancer;
import com.netflix.loadbalancer.ILoadBalancer;
import com.netflix.loadbalancer.IRule;
import com.netflix.loadbalancer.LoadBalancerStats;
import com.netflix.loadbalancer.Server;
import com.netflix.loadbalancer.ServerListFilter;
import io.servicecomb.loadbalance.CseServerList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;

public class LoadBalancer
extends AbstractLoadBalancer {
    private CseServerList serverList;
    private IRule rule;
    private LoadBalancerStats lbStats;
    private Map<String, ServerListFilter<Server>> filters;
    private Object lock = new Object();

    public LoadBalancer(CseServerList serverList, IRule rule) {
        this.serverList = serverList;
        this.rule = rule;
        this.rule.setLoadBalancer((ILoadBalancer)this);
        this.lbStats = new LoadBalancerStats(null);
        this.filters = new ConcurrentHashMap<String, ServerListFilter<Server>>();
    }

    public void addServers(List<Server> newServers) {
        throw new UnsupportedOperationException("Not implemented.");
    }

    public Server chooseServer(Object key) {
        return this.rule.choose(key);
    }

    public void markServerDown(Server server) {
        throw new UnsupportedOperationException("Not implemented.");
    }

    public List<Server> getServerList(boolean availableOnly) {
        return this.getAllServers();
    }

    public List<Server> getReachableServers() {
        return this.getAllServers();
    }

    public List<Server> getAllServers() {
        List servers = this.serverList.getInitialListOfServers();
        for (ServerListFilter<Server> filter : this.filters.values()) {
            servers = filter.getFilteredListOfServers(servers);
        }
        return servers;
    }

    public List<Server> getServerList(AbstractLoadBalancer.ServerGroup serverGroup) {
        throw new UnsupportedOperationException("Not implemented.");
    }

    public LoadBalancerStats getLoadBalancerStats() {
        return this.lbStats;
    }

    public boolean containsFilter(String name) {
        return this.filters.get(name) != null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeFilter(String name) {
        if (this.filters.get(name) != null) {
            Object object = this.lock;
            synchronized (object) {
                if (this.filters.get(name) != null) {
                    this.filters.remove(name);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void putFilter(String name, ServerListFilter<Server> filter) {
        if (this.filters.get(name) == null) {
            Object object = this.lock;
            synchronized (object) {
                if (this.filters.get(name) == null) {
                    this.filters.put(name, filter);
                }
            }
        }
    }

    public int getFilterSize() {
        return this.filters.size();
    }
}

