/*
 * Decompiled with CFR 0.152.
 */
package io.servicecomb.grayrelease.csefilter;

import io.servicecomb.grayrelease.GrayReleaseRulePolicy;
import io.servicecomb.grayrelease.csefilter.AbstractCseRuleGrayReleaseFilter;
import java.util.HashMap;
import java.util.Map;
import java.util.Random;

public class GrayReleaseRatePolicyFilter
extends AbstractCseRuleGrayReleaseFilter {
    private Map<String, String> instanceChooser;
    private static final int RATE_TOTAL = 100;
    private static final String GRAY_RULE_TYPE_RATE = "rate";

    @Override
    protected boolean isReqCompare() {
        return false;
    }

    @Override
    public void fillGrayRules() {
        super.fillGrayRules();
        this.completeRules();
    }

    @Override
    public String grayChooseForGroupIdByRules() {
        this.createInstanceChooser();
        return this.chooseCompute();
    }

    private void completeRules() {
        int rateSum = 0;
        for (GrayReleaseRulePolicy grayReleaseRulePolicy : this.grayRules) {
            String percentageStr = grayReleaseRulePolicy.getPolicy();
            int percentage = Integer.parseInt(percentageStr);
            rateSum += percentage;
        }
        if (rateSum < 100) {
            GrayReleaseRulePolicy grayReleaseRulePolicy = new GrayReleaseRulePolicy("graydefaultgroup", GRAY_RULE_TYPE_RATE, String.valueOf(100 - rateSum));
            this.grayRules.add(grayReleaseRulePolicy);
        }
    }

    private void createInstanceChooser() {
        int chooserIndex = 1;
        this.instanceChooser = new HashMap<String, String>();
        for (GrayReleaseRulePolicy grayReleaseRulePolicy : this.grayRules) {
            String percentageStr = grayReleaseRulePolicy.getPolicy();
            int percentage = Integer.parseInt(percentageStr);
            String chooserStr = new String();
            for (int i = 0; i < percentage; ++i) {
                chooserStr = chooserStr + "||" + String.valueOf(chooserIndex);
                ++chooserIndex;
            }
            this.instanceChooser.put(chooserStr, grayReleaseRulePolicy.getGroupName());
        }
    }

    private String chooseCompute() {
        String chosenGroup = null;
        Random random = new Random();
        String chooseStr = String.valueOf(random.nextInt(100));
        for (Map.Entry<String, String> entry : this.instanceChooser.entrySet()) {
            String chooserStr = entry.getKey();
            if (chooserStr.indexOf(chooseStr) == -1) continue;
            chosenGroup = entry.getValue();
            break;
        }
        return chosenGroup;
    }
}

