/*
 * Decompiled with CFR 0.152.
 */
package io.servicecomb.grayrelease.csefilter;

import io.servicecomb.foundation.common.utils.JsonUtils;
import io.servicecomb.grayrelease.AbstractGrayReleaseFilter;
import io.servicecomb.grayrelease.GrayReleaseGroupPolicy;
import io.servicecomb.grayrelease.GrayReleaseRulePolicy;
import io.servicecomb.loadbalance.Configuration;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public abstract class AbstractCseRuleGrayReleaseFilter
extends AbstractGrayReleaseFilter {
    protected static final String RULE_DETAILS_NAME_KEY = "name";
    protected static final String RULE_DETAILS_VALUE_KEY = "value";
    protected static final String RULE_DETAILS_OBJECTLIST_NAME = "objectList";

    @Override
    protected void fillGrayRules() {
        try {
            String ruleStr = Configuration.INSTANCE.getGrayreleaseRulePolicy(this.invocation.getMicroserviceName(), this.invocation.getMicroserviceQualifiedName());
            if ("".equals(ruleStr) || ruleStr == null) {
                return;
            }
            List grayRuleList = (List)JsonUtils.readValue((byte[])ruleStr.getBytes(StandardCharsets.UTF_8), List.class);
            this.grayRules = new ArrayList();
            for (Map ruleMap : grayRuleList) {
                GrayReleaseRulePolicy grayReleaseGroupPolicy = new GrayReleaseRulePolicy((String)ruleMap.get("group"), (String)ruleMap.get("type"), (String)ruleMap.get("policy"));
                this.grayRules.add(grayReleaseGroupPolicy);
            }
        }
        catch (Exception e) {
            LOGGER.error(this.getClass().getName() + ".fillRules error:" + e);
            this.grayRules = null;
        }
    }

    @Override
    protected void fillGroupRules() {
        try {
            String groupPolicy = Configuration.INSTANCE.getGrayreleaseInstanceGroupRule(this.invocation.getMicroserviceName());
            if ("".equals(groupPolicy) || groupPolicy == null) {
                return;
            }
            List ruleList = (List)JsonUtils.readValue((byte[])groupPolicy.getBytes(StandardCharsets.UTF_8), List.class);
            this.groupRules = new ArrayList();
            for (Map ruleMap : ruleList) {
                GrayReleaseGroupPolicy grayReleaseGroupPolicy = new GrayReleaseGroupPolicy((String)ruleMap.get(RULE_DETAILS_NAME_KEY), (String)ruleMap.get("rule"));
                this.groupRules.add(grayReleaseGroupPolicy);
            }
        }
        catch (Exception e) {
            LOGGER.error(this.getClass().getName() + ".fillGroupRules error:" + e);
            this.groupRules = null;
        }
    }

    @Override
    protected String getGroupNameByGroupRule(String tags, String version) {
        String rGroup = "graydefaultgroup";
        if (this.groupRules == null) {
            return "graydefaultgroup";
        }
        block0: for (GrayReleaseGroupPolicy insGroupRule : this.groupRules) {
            String[] tagsRuleArray;
            List ruleDetailList;
            String groupName = insGroupRule.getGroupName();
            String rule = insGroupRule.getRule();
            Map<String, Object> groupRule = this.parseStrRule(rule);
            String tagRuleValue = null;
            String versionRuleValue = null;
            if (groupRule == null || (ruleDetailList = (List)groupRule.get(RULE_DETAILS_OBJECTLIST_NAME)) == null || ruleDetailList.size() == 0) continue;
            for (String[] ruleDetail : ruleDetailList) {
                if ("version".equals(ruleDetail.get(RULE_DETAILS_NAME_KEY))) {
                    String string = versionRuleValue = ruleDetail.get(RULE_DETAILS_VALUE_KEY) == null ? "microservice.default.version" : (String)ruleDetail.get(RULE_DETAILS_VALUE_KEY);
                }
                if (!"tags".equals(ruleDetail.get(RULE_DETAILS_NAME_KEY))) continue;
                tagRuleValue = ruleDetail.get(RULE_DETAILS_VALUE_KEY) == null ? "NULL" : (String)ruleDetail.get(RULE_DETAILS_VALUE_KEY);
            }
            if (tagRuleValue == null) {
                tagRuleValue = "NULL";
            }
            if (versionRuleValue == null) {
                versionRuleValue = "microservice.default.version";
            }
            if ("NULL".equals(tagRuleValue) && "microservice.default.version".equals(versionRuleValue)) continue;
            if ("NULL".equals(tagRuleValue)) {
                if (!version.equals(versionRuleValue)) continue;
                rGroup = groupName;
                break;
            }
            if ("microservice.default.version".equals(versionRuleValue)) {
                String[] tagsRuleArray2;
                for (String tagRule : tagsRuleArray2 = tagRuleValue.split(",")) {
                    if (!tags.contains(tagRule)) continue;
                    rGroup = groupName;
                    continue block0;
                }
                continue;
            }
            RelateSymbol operator = (RelateSymbol)((Object)groupRule.get("operator"));
            if (operator == null) {
                operator = RelateSymbol.And;
            }
            boolean isTagCompare = false;
            for (String tagRule : tagsRuleArray = tagRuleValue.split(",")) {
                if (!tags.contains(tagRule)) continue;
                isTagCompare = true;
                break;
            }
            if (operator == RelateSymbol.And) {
                if (!isTagCompare || !version.equals(versionRuleValue)) continue;
                rGroup = groupName;
                break;
            }
            if (operator != RelateSymbol.Or || !isTagCompare && !version.equals(versionRuleValue)) continue;
            rGroup = groupName;
            break;
        }
        return rGroup;
    }

    protected Map<String, Object> parseStrRule(String ruleStr) {
        HashMap<String, Object> ruleMap = new HashMap<String, Object>();
        String[] ruleSubStr = null;
        if (ruleStr.contains("||")) {
            ruleSubStr = ruleStr.split("\\|\\|");
            ruleMap.put("operator", (Object)RelateSymbol.Or);
        } else if (ruleStr.contains("&&")) {
            ruleSubStr = ruleStr.split("&&");
            ruleMap.put("operator", (Object)RelateSymbol.And);
        }
        if (ruleSubStr == null) {
            ruleSubStr = new String[]{ruleStr};
        }
        ArrayList objectList = new ArrayList();
        for (String subRuleStr : ruleSubStr) {
            HashMap<String, Object> newSubRule = new HashMap<String, Object>();
            String logicSymbol = "=";
            if (subRuleStr.contains(">")) {
                newSubRule.put("operator", (Object)LogicSymbol.Larger);
                logicSymbol = ">";
            } else if (subRuleStr.contains("<")) {
                newSubRule.put("operator", (Object)LogicSymbol.Smaller);
                logicSymbol = "<";
            } else if (subRuleStr.contains("<=")) {
                newSubRule.put("operator", (Object)LogicSymbol.SmallerOrEqual);
                logicSymbol = "<=";
            } else if (subRuleStr.contains(">=")) {
                newSubRule.put("operator", (Object)LogicSymbol.LargerOrEqual);
                logicSymbol = ">=";
            } else if (subRuleStr.contains("=")) {
                newSubRule.put("operator", (Object)LogicSymbol.Equal);
                logicSymbol = "=";
            } else if (subRuleStr.contains("~")) {
                newSubRule.put("operator", (Object)LogicSymbol.Like);
                logicSymbol = "~";
            } else if (subRuleStr.contains("!=")) {
                newSubRule.put("operator", (Object)LogicSymbol.NotEqual);
                logicSymbol = "!=";
            }
            String[] subStrs = subRuleStr.split(logicSymbol);
            newSubRule.put(RULE_DETAILS_NAME_KEY, subStrs[0]);
            newSubRule.put(RULE_DETAILS_VALUE_KEY, subStrs[1]);
            objectList.add(newSubRule);
        }
        ruleMap.put(RULE_DETAILS_OBJECTLIST_NAME, objectList);
        return ruleMap;
    }

    @Override
    protected void defineInstanceScope() {
        int groupRuleSize = this.groupRules.size();
        ArrayList<String> versions = new ArrayList<String>();
        for (GrayReleaseGroupPolicy insGroupRule : this.groupRules) {
            String ruleStr = insGroupRule.getRule();
            Map<String, Object> groupRule = this.parseStrRule(ruleStr);
            List ruleDetailList = (List)groupRule.get(RULE_DETAILS_OBJECTLIST_NAME);
            String versionValue = "microservice.default.version";
            for (Map ruleDetail : ruleDetailList) {
                if (!"version".equals(ruleDetail.get(RULE_DETAILS_NAME_KEY))) continue;
                versionValue = ruleDetail.get(RULE_DETAILS_VALUE_KEY) == null ? "microservice.default.version" : (String)ruleDetail.get(RULE_DETAILS_VALUE_KEY);
            }
            if ("microservice.default.version".equals(versionValue)) continue;
            versions.add(versionValue);
        }
        int versionRuleCount = versions.size();
        if (versionRuleCount == 0) {
            this.setInstanceScope(AbstractGrayReleaseFilter.InstanceScope.VersionRule);
        } else if (versionRuleCount < groupRuleSize) {
            this.setInstanceScope(AbstractGrayReleaseFilter.InstanceScope.All);
        } else if (versionRuleCount == groupRuleSize) {
            this.setInstanceScope(AbstractGrayReleaseFilter.InstanceScope.PartVersion);
            this.setVersions(versions);
        }
    }

    protected static enum LogicSymbol {
        Larger,
        Smaller,
        Equal,
        Like,
        NotEqual,
        LargerOrEqual,
        SmallerOrEqual;

    }

    protected static enum RelateSymbol {
        And,
        Or;

    }
}

