/*
 * Decompiled with CFR 0.152.
 */
package io.servicecomb.grayrelease;

import io.servicecomb.core.Invocation;
import io.servicecomb.core.handler.impl.AbstractHandler;
import io.servicecomb.grayrelease.AbstractGrayReleaseFilter;
import io.servicecomb.grayrelease.IGrayReleaseFilter;
import io.servicecomb.loadbalance.Configuration;
import io.servicecomb.loadbalance.LoadbalanceHandler;
import io.servicecomb.swagger.invocation.AsyncResponse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GrayReleaseHandler
extends AbstractHandler {
    private static final Logger LOGGER = LoggerFactory.getLogger(LoadbalanceHandler.class);
    private String policy = null;

    public void handle(Invocation invocation, AsyncResponse asyncResp) throws Exception {
        String p;
        this.policy = p = Configuration.INSTANCE.getGrayreleaseRuleClassName(invocation.getMicroserviceName(), invocation.getMicroserviceQualifiedName());
        if (this.policy == null) {
            invocation.next(asyncResp);
        }
        IGrayReleaseFilter rule = this.createGrayReleaseFilterRule(invocation);
        rule.filterRule();
        invocation.next(asyncResp);
    }

    private IGrayReleaseFilter createGrayReleaseFilterRule(Invocation invocation) {
        AbstractGrayReleaseFilter absRule = null;
        try {
            absRule = (AbstractGrayReleaseFilter)Class.forName(this.policy, true, Thread.currentThread().getContextClassLoader()).newInstance();
            absRule.init(invocation);
            LOGGER.info("Using GrayReleaseFilterRule rule [{}] for service [{},{}].", new Object[]{this.policy, invocation.getMicroserviceName(), invocation.getConfigTransportName()});
        }
        catch (ClassNotFoundException | IllegalAccessException | InstantiationException e) {
            LOGGER.warn("GrayReleaseFilterRule rule [{}] is incorrect.", (Object)this.policy);
        }
        return absRule;
    }
}

