/*
 * Decompiled with CFR 0.152.
 */
package io.servicecomb.grayrelease;

import io.servicecomb.core.Invocation;
import io.servicecomb.grayrelease.GrayReleaseGroupPolicy;
import io.servicecomb.grayrelease.GrayReleaseRulePolicy;
import io.servicecomb.grayrelease.IGrayReleaseFilter;
import io.servicecomb.serviceregistry.api.registry.MicroserviceInstance;
import io.servicecomb.serviceregistry.cache.InstanceCacheManager;
import io.servicecomb.serviceregistry.cache.InstanceVersionCacheManager;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractGrayReleaseFilter
implements IGrayReleaseFilter {
    protected static final Logger LOGGER = LoggerFactory.getLogger(AbstractGrayReleaseFilter.class);
    protected Invocation invocation;
    private Map<String, Map<String, MicroserviceInstance>> grayInstanceMap;
    protected List<GrayReleaseGroupPolicy> groupRules;
    protected static final String DEFAULT_INSTANCE_GROUP = "graydefaultgroup";
    protected static final String INSTANCE_GROUP_TAG_KEY = "tags";
    protected static final String INSTANCE_GROUP_VERSION_KEY = "version";
    protected static final String OPERATOR_NAME = "operator";
    protected static final String DEFAULT_MICROSERVICE_VERSION = "microservice.default.version";
    protected static final String GROUP_RULE_NAME_KEY = "name";
    protected static final String GROUP_RULE_RULE_KEY = "rule";
    protected static final String GRAY_RULE_GROUP_KEY = "group";
    protected static final String GRAY_RULE_TYPE_KEY = "type";
    protected static final String GRAY_RULE_POLICY_KEY = "policy";
    protected static final String NULL_STR = "NULL";
    protected List<GrayReleaseRulePolicy> grayRules;
    protected Map<String, Object> reqParams;
    protected InstanceScope instanceScope = InstanceScope.All;
    protected List<String> versions;

    protected void setVersions(List<String> versions) {
        this.versions = versions;
    }

    public Invocation getInvocation() {
        return this.invocation;
    }

    public Map<String, Map<String, MicroserviceInstance>> getGrayInstanceMap() {
        return this.grayInstanceMap;
    }

    public List<GrayReleaseGroupPolicy> getGroupRules() {
        return this.groupRules;
    }

    public List<GrayReleaseRulePolicy> getGrayRules() {
        return this.grayRules;
    }

    public void setGrayRules(List<GrayReleaseRulePolicy> grayRules) {
        this.grayRules = grayRules;
    }

    public void setGroupRules(List<GrayReleaseGroupPolicy> groupRules) {
        this.groupRules = groupRules;
    }

    public void init(Invocation invocation) {
        this.invocation = invocation;
    }

    @Override
    public void filterRule() {
        try {
            this.fillGroupRules();
            if (this.groupRules == null) {
                return;
            }
            this.fillGrayRules();
            if (this.grayRules == null) {
                return;
            }
            if (this.isReqCompare()) {
                this.fillReqParams();
            }
            String chosenGroup = null;
            try {
                this.defineInstanceScope();
                this.fillInstanceGroup();
                chosenGroup = this.grayChooseForGroupIdByRules();
            }
            catch (Exception e) {
                LOGGER.error(this.getClass().getName() + ".filterRule  error:" + e);
                chosenGroup = null;
            }
            this.updateInstanceCache(chosenGroup);
        }
        catch (Exception e) {
            LOGGER.error(this.getClass().getName() + ".filterRule  error:" + e);
            return;
        }
    }

    public Map<String, Object> getReqParams() {
        return this.reqParams;
    }

    protected abstract boolean isReqCompare();

    protected abstract void fillGrayRules();

    protected abstract void fillGroupRules();

    protected abstract void defineInstanceScope();

    protected void setInstanceScope(InstanceScope instanceScope) {
        this.instanceScope = instanceScope;
    }

    private void fillReqParams() {
        int size = this.invocation.getOperationMeta().getParamSize();
        Object[] values = this.invocation.getArgs();
        this.reqParams = new HashMap<String, Object>();
        for (int i = 0; i < size; ++i) {
            this.reqParams.put(this.invocation.getOperationMeta().getParamName(i), values[i]);
        }
    }

    protected abstract String grayChooseForGroupIdByRules();

    protected void fillInstanceGroup() {
        HashMap instanceMap = null;
        switch (this.instanceScope) {
            case All: {
                instanceMap = InstanceVersionCacheManager.INSTANCE.getOrCreateAllMap(this.invocation.getAppId(), this.invocation.getMicroserviceName());
                break;
            }
            case VersionRule: {
                instanceMap = InstanceVersionCacheManager.INSTANCE.getOrCreateVRuleMap(this.invocation.getAppId(), this.invocation.getMicroserviceName(), this.invocation.getMicroserviceVersionRule());
                break;
            }
            case PartVersion: {
                Map allInstance = InstanceVersionCacheManager.INSTANCE.getOrCreateAllMap(this.invocation.getAppId(), this.invocation.getMicroserviceName());
                instanceMap = new HashMap();
                for (String version : this.versions) {
                    instanceMap.put(version, allInstance.get(version));
                }
                break;
            }
            default: {
                instanceMap = InstanceVersionCacheManager.INSTANCE.getOrCreateVRuleMap(this.invocation.getAppId(), this.invocation.getMicroserviceName(), this.invocation.getMicroserviceVersionRule());
            }
        }
        this.groupInstance(instanceMap);
    }

    protected void updateInstanceCache(String chosenGroup) {
        Map<String, MicroserviceInstance> chosenMap;
        if (chosenGroup == null || "".equals(chosenGroup)) {
            chosenMap = null;
        } else if (!DEFAULT_INSTANCE_GROUP.equals(chosenGroup)) {
            chosenMap = this.grayInstanceMap.get(chosenGroup);
        } else {
            HashMap<String, MicroserviceInstance> tmpChosenMap = new HashMap<String, MicroserviceInstance>();
            for (Map.Entry<String, Map<String, MicroserviceInstance>> insGroup : this.grayInstanceMap.entrySet()) {
                String insGroupName = insGroup.getKey();
                if (DEFAULT_INSTANCE_GROUP.equals(insGroupName)) {
                    tmpChosenMap.putAll(insGroup.getValue());
                    continue;
                }
                boolean isRemark = false;
                for (GrayReleaseRulePolicy grayReleaseRulePolicy : this.grayRules) {
                    if (!grayReleaseRulePolicy.getGroupName().equals(insGroupName)) continue;
                    isRemark = true;
                    break;
                }
                if (isRemark) continue;
                tmpChosenMap.putAll(insGroup.getValue());
            }
            chosenMap = tmpChosenMap;
        }
        if (chosenMap == null) {
            Map defaultInstanceVersionMap = InstanceVersionCacheManager.INSTANCE.getOrCreateVRuleMap(this.invocation.getAppId(), this.invocation.getMicroserviceName(), this.invocation.getMicroserviceVersionRule());
            HashMap<String, MicroserviceInstance> defaultInstanceMap = new HashMap<String, MicroserviceInstance>();
            for (Map.Entry defaultInstanceVersion : defaultInstanceVersionMap.entrySet()) {
                defaultInstanceMap.putAll((Map)defaultInstanceVersion.getValue());
            }
            chosenMap = defaultInstanceMap;
        }
        InstanceCacheManager.INSTANCE.updateInstanceMap(this.invocation.getAppId(), this.invocation.getMicroserviceName(), this.invocation.getMicroserviceVersionRule(), chosenMap);
    }

    private void groupInstance(Map<String, Map<String, MicroserviceInstance>> instanceMap) {
        this.grayInstanceMap = new HashMap<String, Map<String, MicroserviceInstance>>();
        for (Map.Entry<String, Map<String, MicroserviceInstance>> instanceVersionMap : instanceMap.entrySet()) {
            String version = instanceVersionMap.getKey();
            Map<String, MicroserviceInstance> instances = instanceVersionMap.getValue();
            for (Map.Entry<String, MicroserviceInstance> instanceEntry : instances.entrySet()) {
                Map<Object, Object> members;
                String groupName;
                String instanceId = instanceEntry.getKey();
                MicroserviceInstance instance = instanceEntry.getValue();
                if (DEFAULT_MICROSERVICE_VERSION.equals(version) && instance.getProperties().isEmpty()) {
                    Map<Object, Object> defaultMap;
                    if (this.grayInstanceMap.get(DEFAULT_INSTANCE_GROUP) == null) {
                        defaultMap = new HashMap<String, MicroserviceInstance>();
                        defaultMap.put(instanceId, instance);
                        this.grayInstanceMap.put(DEFAULT_INSTANCE_GROUP, defaultMap);
                        continue;
                    }
                    defaultMap = this.grayInstanceMap.get(DEFAULT_INSTANCE_GROUP);
                    defaultMap.put(instanceId, instance);
                    continue;
                }
                String tags = NULL_STR;
                if (instance.getProperties().get(INSTANCE_GROUP_TAG_KEY) != null && !"".equals(instance.getProperties().get(INSTANCE_GROUP_TAG_KEY))) {
                    tags = (String)instance.getProperties().get(INSTANCE_GROUP_TAG_KEY);
                }
                if (this.grayInstanceMap.get(groupName = this.getGroupNameByGroupRule(tags, version)) == null) {
                    members = new HashMap<String, MicroserviceInstance>();
                    members.put(instanceId, instance);
                    this.grayInstanceMap.put(groupName, members);
                    continue;
                }
                members = this.grayInstanceMap.get(groupName);
                members.put(instanceId, instance);
            }
        }
    }

    protected abstract String getGroupNameByGroupRule(String var1, String var2);

    public static enum InstanceScope {
        All,
        VersionRule,
        PartVersion;

    }
}

