/*
 * Decompiled with CFR 0.152.
 */
package io.servicecomb.qps;

import io.servicecomb.core.Invocation;
import io.servicecomb.core.handler.impl.AbstractHandler;
import io.servicecomb.qps.Config;
import io.servicecomb.qps.ProviderQpsControllerManager;
import io.servicecomb.qps.QpsConst;
import io.servicecomb.qps.QpsController;
import io.servicecomb.swagger.invocation.AsyncResponse;
import io.servicecomb.swagger.invocation.exception.CommonExceptionData;
import io.servicecomb.swagger.invocation.exception.InvocationException;

public class ProviderQpsFlowControlHandler
extends AbstractHandler {
    private ProviderQpsControllerManager qpsControllerMgr = new ProviderQpsControllerManager();

    public void handle(Invocation invocation, AsyncResponse asyncResp) throws Exception {
        QpsController qpsController;
        if (!Config.INSTANCE.isProviderEnabled()) {
            invocation.next(asyncResp);
            return;
        }
        String microServiceName = (String)invocation.getContext("x-cse-src-microservice");
        if (microServiceName != null && !microServiceName.isEmpty() && this.isLimitNewRequest(qpsController = this.qpsControllerMgr.getOrCreate(microServiceName), asyncResp)) {
            return;
        }
        QpsController globalQpsController = this.qpsControllerMgr.getOrCreate(null);
        if (this.isLimitNewRequest(globalQpsController, asyncResp)) {
            return;
        }
        invocation.next(asyncResp);
    }

    private boolean isLimitNewRequest(QpsController qpsController, AsyncResponse asyncResp) {
        if (qpsController.isLimitNewRequest()) {
            CommonExceptionData errorData = new CommonExceptionData("rejected by qps flowcontrol");
            asyncResp.producerFail((Throwable)new InvocationException(QpsConst.TOO_MANY_REQUESTS_STATUS, (Object)errorData));
            return true;
        }
        return false;
    }
}

