/*
 * Decompiled with CFR 0.152.
 */
package io.servicecomb.qps;

import com.netflix.config.DynamicProperty;
import io.servicecomb.foundation.common.AbstractObjectManager;
import io.servicecomb.qps.QpsController;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ProviderQpsControllerManager
extends AbstractObjectManager<String, String, QpsController> {
    private static final Logger LOGGER = LoggerFactory.getLogger(ProviderQpsControllerManager.class);
    private Map<String, QpsController> qpsControllerMap = new ConcurrentHashMap<String, QpsController>();
    private Set<String> watchedKeySet = new HashSet<String>();
    private QpsController globalQpsController = null;

    protected String getKey(String microServiceName) {
        return microServiceName;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public QpsController getOrCreate(String keyOwner) {
        if (keyOwner == null) {
            if (this.globalQpsController == null) {
                Object object = this.lockObj;
                synchronized (object) {
                    if (this.globalQpsController == null) {
                        DynamicProperty property = DynamicProperty.getInstance((String)"cse.flowcontrol.Provider.qps.global.limit");
                        this.globalQpsController = new QpsController(keyOwner, this.getIntegerLimitProperty(property));
                        property.addCallback(() -> this.globalQpsController.setQpsLimit(this.getIntegerLimitProperty(property)));
                    }
                }
            }
            return this.globalQpsController;
        }
        return (QpsController)super.getOrCreate((Object)keyOwner);
    }

    private QpsController initQpsLimit(String key, Integer qpsLimit) {
        if (qpsLimit == null) {
            qpsLimit = null;
        }
        LOGGER.info("qpsLimit of {} init as {}", (Object)key, (Object)qpsLimit);
        QpsController qpsController = new QpsController(key, qpsLimit);
        this.qpsControllerMap.put(key, qpsController);
        return qpsController;
    }

    private QpsController updateQpsLimit(String key, Integer qpsLimit) {
        QpsController qpsController = this.qpsControllerMap.get(key);
        if (qpsController == null && qpsLimit != null) {
            qpsController = new QpsController(key, qpsLimit);
            this.qpsControllerMap.put(key, qpsController);
        }
        if (qpsController != null) {
            LOGGER.info("qpsLimit of {} changed from {} to {}", new Object[]{key, qpsController.getQpsLimit(), qpsLimit});
            qpsController.setQpsLimit(qpsLimit);
        }
        return qpsController;
    }

    private QpsController findReference(String key) {
        QpsController qpsController = this.qpsControllerMap.get(key);
        if (qpsController == null) {
            return this.initQpsLimit(key, Integer.MAX_VALUE);
        }
        return qpsController;
    }

    protected QpsController create(String microServiceName) {
        this.initConfig(microServiceName);
        return this.findReference(microServiceName);
    }

    private void initConfig(String key) {
        if (this.watchedKeySet.contains(key)) {
            return;
        }
        this.watchedKeySet.add(key);
        String configKey = "cse.flowcontrol.Provider.qps.limit." + key;
        DynamicProperty property = DynamicProperty.getInstance((String)configKey);
        this.initQpsLimit(key, this.getIntegerLimitProperty(property));
        property.addCallback(() -> {
            this.updateQpsLimit(key, this.getIntegerLimitProperty(property));
            QpsController qpsController = this.findReference(key);
            this.objMap.put(key, qpsController);
        });
    }

    private Integer getIntegerLimitProperty(DynamicProperty property) {
        try {
            return property.getInteger();
        }
        catch (IllegalArgumentException e) {
            LOGGER.error(e.getMessage());
            return null;
        }
    }
}

