/*
 * Decompiled with CFR 0.152.
 */
package io.servicecomb.qps;

import com.netflix.config.DynamicProperty;
import io.servicecomb.core.definition.OperationMeta;
import io.servicecomb.foundation.common.AbstractObjectManager;
import io.servicecomb.qps.QpsController;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ConsumerQpsControllerManager
extends AbstractObjectManager<OperationMeta, String, QpsController> {
    private static final Logger LOGGER = LoggerFactory.getLogger(ConsumerQpsControllerManager.class);
    private Map<String, QpsController> qpsControllerMap = new ConcurrentHashMap<String, QpsController>();
    private Set<String> watchedKeySet = new HashSet<String>();

    protected String getKey(OperationMeta operationMeta) {
        return operationMeta.getMicroserviceQualifiedName();
    }

    private QpsController initQpsLimit(String key, Integer qpsLimit) {
        if (qpsLimit == null) {
            return null;
        }
        LOGGER.info("qpsLimit of {} init as {}", (Object)key, (Object)qpsLimit);
        QpsController qpsController = new QpsController(key, qpsLimit);
        this.qpsControllerMap.put(key, qpsController);
        return qpsController;
    }

    private QpsController updateQpsLimit(String key, Integer qpsLimit) {
        QpsController qpsController = this.qpsControllerMap.get(key);
        if (qpsController == null && qpsLimit != null) {
            qpsController = new QpsController(key, qpsLimit);
            this.qpsControllerMap.put(key, qpsController);
        }
        if (qpsController != null) {
            LOGGER.info("qpsLimit of {} changed from {} to {}", new Object[]{key, qpsController.getQpsLimit(), qpsLimit});
            qpsController.setQpsLimit(qpsLimit);
        }
        return qpsController;
    }

    private QpsController findReference(String key) {
        QpsController qpsController = this.qpsControllerMap.get(key);
        if (qpsController == null) {
            return null;
        }
        if (qpsController.getQpsLimit() == null) {
            return null;
        }
        return qpsController;
    }

    private QpsController findReference(OperationMeta operationMeta) {
        QpsController qpsController = this.findReference(operationMeta.getMicroserviceQualifiedName());
        if (qpsController != null) {
            return qpsController;
        }
        qpsController = this.findReference(operationMeta.getSchemaMeta().getMicroserviceQualifiedName());
        if (qpsController != null) {
            return qpsController;
        }
        qpsController = this.findReference(operationMeta.getMicroserviceName());
        if (qpsController != null) {
            return qpsController;
        }
        return this.initQpsLimit(operationMeta.getMicroserviceName(), Integer.MAX_VALUE);
    }

    protected QpsController create(OperationMeta operationMeta) {
        this.initConfig(operationMeta, operationMeta.getMicroserviceQualifiedName());
        this.initConfig(operationMeta, operationMeta.getSchemaMeta().getMicroserviceQualifiedName());
        this.initConfig(operationMeta, operationMeta.getMicroserviceName());
        return this.findReference(operationMeta);
    }

    private void initConfig(OperationMeta operationMeta, String key) {
        if (this.watchedKeySet.contains(key)) {
            return;
        }
        this.watchedKeySet.add(key);
        String configKey = "cse.flowcontrol.Consumer.qps.limit." + key;
        DynamicProperty property = DynamicProperty.getInstance((String)configKey);
        this.initQpsLimit(key, this.getIntegerLimitProperty(property));
        property.addCallback(() -> {
            this.updateQpsLimit(key, this.getIntegerLimitProperty(property));
            QpsController qpsController = this.findReference(operationMeta);
            this.objMap.put(operationMeta.getMicroserviceQualifiedName(), qpsController);
        });
        this.initQpsLimit(key, property.getInteger());
    }

    private Integer getIntegerLimitProperty(DynamicProperty property) {
        try {
            return property.getInteger();
        }
        catch (IllegalArgumentException e) {
            LOGGER.error(e.getMessage());
            return null;
        }
    }
}

