/*
 * Decompiled with CFR 0.152.
 */
package seatsio.util;

import java.util.Iterator;
import java.util.Map;
import seatsio.util.Page;
import seatsio.util.PageFetcher;

public class PagedIterator<T>
implements Iterator<T> {
    private final PageFetcher<T> pageFetcher;
    private final Map<String, Object> parameters;
    private Page<T> currentPage;
    private int indexInCurrentPage = 0;

    PagedIterator(PageFetcher<T> pageFetcher, Map<String, Object> parameters) {
        this.pageFetcher = pageFetcher;
        this.parameters = parameters;
    }

    @Override
    public boolean hasNext() {
        Page<T> page = this.getCurrentPage();
        return this.indexInCurrentPage < page.items.size();
    }

    @Override
    public T next() {
        return this.getCurrentPage().items.get(this.indexInCurrentPage++);
    }

    private Page<T> getCurrentPage() {
        if (this.currentPage == null) {
            this.currentPage = this.pageFetcher.fetchFirstPage(this.parameters, null);
        } else if (this.nextPageMustBeFetched()) {
            this.currentPage = this.pageFetcher.fetchAfter(this.currentPage.nextPageStartsAfter.get(), this.parameters, null);
            this.indexInCurrentPage = 0;
        }
        return this.currentPage;
    }

    private boolean nextPageMustBeFetched() {
        return this.indexInCurrentPage >= this.currentPage.items.size() && this.currentPage.nextPageStartsAfter.isPresent();
    }
}

