/*
 * Decompiled with CFR 0.152.
 */
package seatsio.util;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Spliterator;
import java.util.Spliterators;
import java.util.stream.Collectors;
import java.util.stream.StreamSupport;
import kong.unirest.HttpRequest;
import seatsio.json.SeatsioGson;
import seatsio.util.Page;
import seatsio.util.UnirestWrapper;

public class PageFetcher<T> {
    private final String baseUrl;
    private final String url;
    private final UnirestWrapper unirest;
    private final Map<String, String> routeParams;
    private final Map<String, String> queryParams;
    private final Class<T> clazz;

    public PageFetcher(String baseUrl, String url, UnirestWrapper unirest, Class<T> clazz) {
        this.baseUrl = baseUrl;
        this.unirest = unirest;
        this.url = url;
        this.routeParams = new HashMap<String, String>();
        this.queryParams = new HashMap<String, String>();
        this.clazz = clazz;
    }

    public PageFetcher(String baseUrl, String url, Map<String, String> routeParams, UnirestWrapper unirest, Class<T> clazz) {
        this.baseUrl = baseUrl;
        this.url = url;
        this.routeParams = routeParams;
        this.unirest = unirest;
        this.queryParams = new HashMap<String, String>();
        this.clazz = clazz;
    }

    public PageFetcher(String baseUrl, String url, Map<String, String> routeParams, Map<String, String> queryParams, UnirestWrapper unirest, Class<T> clazz) {
        this.baseUrl = baseUrl;
        this.url = url;
        this.queryParams = queryParams;
        this.routeParams = routeParams;
        this.unirest = unirest;
        this.clazz = clazz;
    }

    public Page<T> fetchFirstPage(Map<String, Object> parameters, Integer pageSize) {
        return this.fetch(this.buildRequest(parameters, pageSize));
    }

    public Page<T> fetchAfter(long id, Map<String, Object> parameters, Integer pageSize) {
        HttpRequest request = this.buildRequest(parameters, pageSize);
        request.queryString("start_after_id", (Object)id);
        return this.fetch(request);
    }

    public Page<T> fetchBefore(long id, Map<String, Object> parameters, Integer pageSize) {
        HttpRequest request = this.buildRequest(parameters, pageSize);
        request.queryString("end_before_id", (Object)id);
        return this.fetch(request);
    }

    private HttpRequest buildRequest(Map<String, Object> parameters, Integer pageSize) {
        HttpRequest request = UnirestWrapper.get(this.baseUrl + this.url).queryString(parameters);
        this.routeParams.forEach((arg_0, arg_1) -> ((HttpRequest)request).routeParam(arg_0, arg_1));
        this.queryParams.entrySet().stream().filter(entry -> entry.getValue() != null).forEach(entry -> request.queryString((String)entry.getKey(), entry.getValue()));
        if (pageSize != null) {
            request.queryString("limit", (Object)pageSize);
        }
        return request;
    }

    private Page<T> fetch(HttpRequest request) {
        String response = this.unirest.stringResponse(request);
        JsonObject responseJson = JsonParser.parseString((String)response).getAsJsonObject();
        List<T> items = PageFetcher.asList(responseJson.getAsJsonArray("items"), this.clazz);
        return new Page<T>(items, this.optionalLong(responseJson.get("next_page_starts_after")), this.optionalLong(responseJson.get("previous_page_ends_before")));
    }

    private Optional<Long> optionalLong(JsonElement element) {
        return element != null ? Optional.of(element.getAsJsonPrimitive().getAsLong()) : Optional.empty();
    }

    private static <T> List<T> asList(JsonArray jsonArray, Class<T> clazz) {
        Iterator itemsIterator = jsonArray.iterator();
        Spliterator itemsSpliterator = Spliterators.spliteratorUnknownSize(itemsIterator, 16);
        return StreamSupport.stream(itemsSpliterator, false).map(itemJson -> SeatsioGson.gson().fromJson(itemJson, clazz)).collect(Collectors.toList());
    }
}

