/*
 * Decompiled with CFR 0.152.
 */
package seatsio.seasons;

import java.util.List;
import kong.unirest.HttpRequest;
import kong.unirest.HttpRequestWithBody;
import seatsio.SeatsioClient;
import seatsio.events.Event;
import seatsio.events.EventCreationResult;
import seatsio.json.JsonObjectBuilder;
import seatsio.json.SeatsioGson;
import seatsio.seasons.Season;
import seatsio.seasons.SeasonParams;
import seatsio.util.UnirestWrapper;

public class Seasons {
    private final String baseUrl;
    private final UnirestWrapper unirest;
    private SeatsioClient seatsioClient;

    public Seasons(String baseUrl, UnirestWrapper unirest, SeatsioClient seatsioClient) {
        this.baseUrl = baseUrl;
        this.unirest = unirest;
        this.seatsioClient = seatsioClient;
    }

    public Season create(String chartKey) {
        return this.create(chartKey, new SeasonParams());
    }

    public Season create(String chartKey, SeasonParams seasonParams) {
        JsonObjectBuilder request = JsonObjectBuilder.aJsonObject().withProperty("chartKey", chartKey).withPropertyIfNotNull("key", seasonParams.key()).withPropertyIfNotNull("eventKeys", seasonParams.eventKeys()).withPropertyIfNotNull("numberOfEvents", seasonParams.numberOfEvents()).withPropertyIfNotNull("tableBookingConfig", seasonParams.tableBookingConfig()).withPropertyIfNotNull("channels", seasonParams.getChannelsAsJson());
        String response = this.unirest.stringResponse((HttpRequest)UnirestWrapper.post(this.baseUrl + "/seasons").body(request.build().toString()));
        return (Season)SeatsioGson.gson().fromJson(response, Season.class);
    }

    public List<Event> createEvents(String key, List<String> eventKeys) {
        return this.doCreateEvents(key, eventKeys, null);
    }

    public List<Event> createEvents(String key, int numberOfEvents) {
        return this.doCreateEvents(key, null, numberOfEvents);
    }

    private List<Event> doCreateEvents(String key, List<String> eventKeys, Integer numberOfEvents) {
        JsonObjectBuilder request = JsonObjectBuilder.aJsonObject().withPropertyIfNotNull("eventKeys", eventKeys).withPropertyIfNotNull("numberOfEvents", numberOfEvents);
        String response = this.unirest.stringResponse((HttpRequest)((HttpRequestWithBody)UnirestWrapper.post(this.baseUrl + "/seasons/{key}/actions/create-events").routeParam("key", key)).body(request.build().toString()));
        return ((EventCreationResult)SeatsioGson.gson().fromJson((String)response, EventCreationResult.class)).events;
    }

    public Season createPartialSeason(String topLevelSeasonKey, String key, List<String> eventKeys) {
        JsonObjectBuilder request = JsonObjectBuilder.aJsonObject().withPropertyIfNotNull("key", key).withPropertyIfNotNull("eventKeys", eventKeys);
        String response = this.unirest.stringResponse((HttpRequest)((HttpRequestWithBody)UnirestWrapper.post(this.baseUrl + "/seasons/{topLevelSeasonKey}/partial-seasons").routeParam("topLevelSeasonKey", topLevelSeasonKey)).body(request.build().toString()));
        return (Season)SeatsioGson.gson().fromJson(response, Season.class);
    }

    public Season removeEventFromPartialSeason(String topLevelSeasonKey, String partialSeasonKey, String eventKey) {
        String response = this.unirest.stringResponse(((HttpRequestWithBody)((HttpRequestWithBody)UnirestWrapper.delete(this.baseUrl + "/seasons/{topLevelSeasonKey}/partial-seasons/{partialSeasonKey}/events/{eventKey}").routeParam("topLevelSeasonKey", topLevelSeasonKey)).routeParam("partialSeasonKey", partialSeasonKey)).routeParam("eventKey", eventKey));
        return (Season)SeatsioGson.gson().fromJson(response, Season.class);
    }

    public Season addEventsToPartialSeason(String topLevelSeasonKey, String partialSeasonKey, List<String> eventKeys) {
        JsonObjectBuilder request = JsonObjectBuilder.aJsonObject().withProperty("eventKeys", eventKeys);
        String response = this.unirest.stringResponse((HttpRequest)((HttpRequestWithBody)((HttpRequestWithBody)UnirestWrapper.post(this.baseUrl + "/seasons/{topLevelSeasonKey}/partial-seasons/{partialSeasonKey}/actions/add-events").routeParam("topLevelSeasonKey", topLevelSeasonKey)).routeParam("partialSeasonKey", partialSeasonKey)).body(request.build().toString()));
        return (Season)SeatsioGson.gson().fromJson(response, Season.class);
    }

    public Season retrieve(String key) {
        return (Season)this.seatsioClient.events.retrieve(key);
    }
}

