/*
 * Decompiled with CFR 0.152.
 */
package seatsio.reports.usage;

import com.google.gson.JsonArray;
import com.google.gson.JsonParser;
import com.google.gson.reflect.TypeToken;
import java.util.List;
import kong.unirest.GetRequest;
import kong.unirest.HttpRequest;
import seatsio.json.SeatsioGson;
import seatsio.reports.usage.Month;
import seatsio.reports.usage.detailsForEventInMonth.UsageForObjectV1;
import seatsio.reports.usage.detailsForEventInMonth.UsageForObjectV2;
import seatsio.reports.usage.detailsForMonth.UsageDetails;
import seatsio.reports.usage.summaryForMonths.UsageSummaryForMonth;
import seatsio.util.UnirestWrapper;

public class UsageReports {
    private final String baseUrl;
    private final UnirestWrapper unirest;

    public UsageReports(String baseUrl, UnirestWrapper unirest) {
        this.baseUrl = baseUrl;
        this.unirest = unirest;
    }

    public List<UsageSummaryForMonth> summaryForAllMonths() {
        String response = this.unirest.stringResponse((HttpRequest)UnirestWrapper.get(this.baseUrl + "/reports/usage"));
        TypeToken<List<UsageSummaryForMonth>> typeToken = new TypeToken<List<UsageSummaryForMonth>>(){};
        return (List)SeatsioGson.gson().fromJson(response, typeToken.getType());
    }

    public List<UsageDetails> detailsForMonth(Month month) {
        String response = this.unirest.stringResponse(UnirestWrapper.get(this.baseUrl + "/reports/usage/month/{month}").routeParam("month", month.serialize()));
        TypeToken<List<UsageDetails>> typeToken = new TypeToken<List<UsageDetails>>(){};
        return (List)SeatsioGson.gson().fromJson(response, typeToken.getType());
    }

    public List<?> detailsForEventInMonth(long eventId, Month month) {
        String response = this.unirest.stringResponse(((GetRequest)UnirestWrapper.get(this.baseUrl + "/reports/usage/month/{month}/event/{eventId}").routeParam("month", month.serialize())).routeParam("eventId", Long.toString(eventId)));
        JsonArray json = JsonParser.parseString((String)response).getAsJsonArray();
        if (!json.isEmpty() && json.get(0).getAsJsonObject().has("usageByReason")) {
            return UsageReports.detailsForEventInMonthV2(response);
        }
        return UsageReports.detailsForEventInMonthV1(response);
    }

    private static List<UsageForObjectV1> detailsForEventInMonthV1(String response) {
        TypeToken<List<UsageForObjectV1>> typeToken = new TypeToken<List<UsageForObjectV1>>(){};
        return (List)SeatsioGson.gson().fromJson(response, typeToken.getType());
    }

    private static List<UsageForObjectV2> detailsForEventInMonthV2(String response) {
        TypeToken<List<UsageForObjectV2>> typeToken = new TypeToken<List<UsageForObjectV2>>(){};
        return (List)SeatsioGson.gson().fromJson(response, typeToken.getType());
    }
}

