/*
 * Decompiled with CFR 0.152.
 */
package seatsio.reports;

import com.google.gson.reflect.TypeToken;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import kong.unirest.GetRequest;
import seatsio.json.SeatsioGson;
import seatsio.util.UnirestWrapper;

public abstract class Reports {
    protected final String baseUrl;
    private final String reportItemType;
    private final UnirestWrapper unirest;

    public Reports(String baseUrl, String reportItemType, UnirestWrapper unirest) {
        this.baseUrl = baseUrl;
        this.reportItemType = reportItemType;
        this.unirest = unirest;
    }

    private String fetchRawReport(String reportType, String key, Map<String, Object> queryParams) {
        return this.unirest.stringResponse(((GetRequest)((GetRequest)UnirestWrapper.get(this.baseUrl + "/reports/" + this.reportItemType + "/{key}/{reportType}").queryString(queryParams)).routeParam("key", key)).routeParam("reportType", reportType));
    }

    protected final <T> Map<String, List<T>> fetchReport(String reportType, String key) {
        return this.fetchReport(reportType, key, null);
    }

    protected final <T> Map<String, List<T>> fetchReport(String reportType, String key, Map<String, Object> queryParams) {
        String result = this.fetchRawReport(reportType, key, queryParams);
        TypeToken<Map<String, List<T>>> typeToken = this.getTypeToken();
        return (Map)SeatsioGson.gson().fromJson(result, typeToken.getType());
    }

    protected <T> List<T> fetchReportFiltered(String reportType, String eventKey, String filter) {
        return this.fetchReport(reportType, eventKey, null).getOrDefault(filter, new ArrayList());
    }

    protected abstract <T> TypeToken<Map<String, List<T>>> getTypeToken();

    protected <T> Map<String, T> fetchSummaryReport(String reportType, String key) {
        return this.fetchSummaryReport(reportType, key, null);
    }

    protected <T> Map<String, T> fetchSummaryReport(String reportType, String key, Map<String, Object> queryParams) {
        String result = this.fetchRawSummaryReport(reportType, key, queryParams);
        TypeToken<Map<String, T>> typeToken = this.getSummaryTypeToken();
        return (Map)SeatsioGson.gson().fromJson(result, typeToken.getType());
    }

    protected abstract <T> TypeToken<Map<String, T>> getSummaryTypeToken();

    private String fetchRawSummaryReport(String reportType, String key, Map<String, Object> queryParams) {
        return this.unirest.stringResponse(((GetRequest)((GetRequest)UnirestWrapper.get(this.baseUrl + "/reports/" + this.reportItemType + "/{key}/{reportType}/summary").queryString(queryParams)).routeParam("key", key)).routeParam("reportType", reportType));
    }
}

