/*
 * Decompiled with CFR 0.152.
 */
package seatsio.json;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonDeserializer;
import com.google.gson.JsonElement;
import com.google.gson.JsonParseException;
import com.google.gson.JsonPrimitive;
import com.google.gson.JsonSerializationContext;
import com.google.gson.JsonSerializer;
import java.lang.reflect.Type;
import java.time.Instant;
import java.time.LocalDate;
import seatsio.charts.CategoryKey;
import seatsio.events.Event;

public class SeatsioGson {
    public static Gson gson() {
        return SeatsioGson.gsonBuilder().registerTypeAdapter(Event.class, (Object)new Event.EventJsonDeserializer()).create();
    }

    public static GsonBuilder gsonBuilder() {
        return new GsonBuilder().registerTypeAdapter(Instant.class, (Object)new InstantDeserializer()).registerTypeAdapter(LocalDate.class, (Object)new LocalDateSerializer()).registerTypeAdapter(LocalDate.class, (Object)new LocalDateDeserializer()).registerTypeAdapter(CategoryKey.class, (Object)new CategoryKey.CategoryKeyJsonDeserializer()).registerTypeAdapter(CategoryKey.class, (Object)new CategoryKey.CategoryKeyJsonSerializer());
    }

    private static class InstantDeserializer
    implements JsonDeserializer<Instant> {
        private InstantDeserializer() {
        }

        public Instant deserialize(JsonElement json, Type typeOfT, JsonDeserializationContext context) throws JsonParseException {
            return Instant.parse(json.getAsJsonPrimitive().getAsString());
        }
    }

    private static class LocalDateSerializer
    implements JsonSerializer<LocalDate> {
        private LocalDateSerializer() {
        }

        public JsonElement serialize(LocalDate date, Type typeOfSrc, JsonSerializationContext context) {
            return new JsonPrimitive(date.toString());
        }
    }

    private static class LocalDateDeserializer
    implements JsonDeserializer<LocalDate> {
        private LocalDateDeserializer() {
        }

        public LocalDate deserialize(JsonElement json, Type typeOfT, JsonDeserializationContext context) throws JsonParseException {
            return LocalDate.parse(json.getAsJsonPrimitive().getAsString());
        }
    }
}

