/*
 * Decompiled with CFR 0.152.
 */
package seatsio.json;

import com.google.common.base.Function;
import com.google.common.collect.Maps;
import com.google.gson.Gson;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonNull;
import com.google.gson.JsonObject;
import com.google.gson.JsonPrimitive;
import java.util.Arrays;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import seatsio.json.JsonArrayBuilder;

public class JsonObjectBuilder {
    private Map<String, JsonElement> properties = new LinkedHashMap<String, JsonElement>();

    public static JsonObjectBuilder aJsonObject() {
        return new JsonObjectBuilder();
    }

    public JsonObject build() {
        JsonObject o = new JsonObject();
        for (Map.Entry<String, JsonElement> entry : this.properties.entrySet()) {
            o.add(entry.getKey(), entry.getValue());
        }
        return o;
    }

    public String buildAsString() {
        return this.build().toString();
    }

    public JsonObjectBuilder withProperty(String propertyName, Boolean value) {
        return this.setValue(propertyName, value, JsonPrimitive::new);
    }

    public <E extends Enum> JsonObjectBuilder withProperty(String propertyName, E e) {
        return this.withProperty(propertyName, e.toString());
    }

    public JsonObjectBuilder withProperty(String propertyName, String value) {
        return this.setValue(propertyName, value, JsonPrimitive::new);
    }

    public JsonObjectBuilder withProperty(String propertyName, Number value) {
        return this.setValue(propertyName, value, JsonPrimitive::new);
    }

    public JsonObjectBuilder withProperty(String propertyName, Character value) {
        return this.setValue(propertyName, value, JsonPrimitive::new);
    }

    public JsonObjectBuilder withProperty(String propertyName, String[] values) {
        return this.withProperty(propertyName, Arrays.asList(values));
    }

    public JsonObjectBuilder withProperty(String propertyName, Collection<String> values) {
        return this.withProperty(propertyName, values, JsonPrimitive::new);
    }

    public <T extends JsonElement> JsonObjectBuilder withProperties(Map<String, T> properties) {
        properties.forEach(this::withProperty);
        return this;
    }

    public <T> JsonObjectBuilder withProperties(Map<String, T> properties, Function<T, JsonElement> f) {
        return this.withProperties(Maps.transformValues(properties, f));
    }

    public <T> JsonObjectBuilder withProperty(String propertyName, Collection<T> values, java.util.function.Function<T, JsonElement> f) {
        Collection collect = values.stream().map(f).collect(Collectors.toList());
        JsonArray array = JsonArrayBuilder.aJsonArray().withItems(collect).build();
        return this.withProperty(propertyName, (JsonElement)array);
    }

    public JsonObjectBuilder withPropertyIfNotNull(String propertyName, String value) {
        if (value == null) {
            return this;
        }
        return this.withProperty(propertyName, value);
    }

    public JsonObjectBuilder withPropertyIfNotNull(String propertyName, Boolean value) {
        if (value == null) {
            return this;
        }
        return this.withProperty(propertyName, value);
    }

    public <T> JsonObjectBuilder withPropertyIfNotNull(String propertyName, Collection<T> values, java.util.function.Function<T, JsonElement> f) {
        if (values == null) {
            return this;
        }
        return this.withProperty(propertyName, values, f);
    }

    public JsonObjectBuilder withPropertyIfNotNull(String propertyName, Collection<String> values) {
        if (values == null) {
            return this;
        }
        return this.withProperty(propertyName, values);
    }

    public JsonObjectBuilder withPropertyIfNotNull(String propertyName, Object value) {
        if (value == null) {
            return this;
        }
        return this.withProperty(propertyName, new Gson().toJsonTree(value));
    }

    public <T> JsonObjectBuilder withPropertyIfNotNull(String propertyName, Map<String, T> map, java.util.function.Function<T, JsonElement> f) {
        if (map == null) {
            return this;
        }
        Map<String, JsonElement> appliedMap = map.entrySet().stream().collect(Collectors.toMap(Map.Entry::getKey, t -> (JsonElement)f.apply(t.getValue())));
        return this.withProperty(propertyName, new Gson().toJsonTree(appliedMap));
    }

    private <T> JsonObjectBuilder setValue(String propertyName, T value, java.util.function.Function<T, JsonPrimitive> f) {
        if (value == null) {
            return this.withNullProperty(propertyName);
        }
        return this.withProperty(propertyName, (JsonElement)f.apply(value));
    }

    private JsonObjectBuilder withNullProperty(String propertyName) {
        this.properties.put(propertyName, (JsonElement)JsonNull.INSTANCE);
        return this;
    }

    public JsonObjectBuilder withProperty(String propertyName, JsonElement json) {
        this.properties.put(propertyName, json);
        return this;
    }

    public JsonObjectBuilder withoutProperty(String propertyName) {
        this.properties.remove(propertyName);
        return this;
    }

    public JsonObjectBuilder withProperty(String propertyName, Optional<String> optionalValue) {
        if (optionalValue.isPresent()) {
            return this.withProperty(propertyName, optionalValue.get());
        }
        return this;
    }
}

