/*
 * Decompiled with CFR 0.152.
 */
package seatsio.json;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonPrimitive;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.stream.Collectors;

public class JsonArrayBuilder {
    private Collection<JsonElement> items = new ArrayList<JsonElement>();

    public static JsonArrayBuilder aJsonArray() {
        return new JsonArrayBuilder();
    }

    public JsonArrayBuilder withItems(JsonElement ... items) {
        return this.withItems(Arrays.asList(items));
    }

    public JsonArrayBuilder withItems(String ... items) {
        List<JsonElement> itemsAsJsonElement = Arrays.stream(items).map(JsonPrimitive::new).collect(Collectors.toList());
        return this.withItems(itemsAsJsonElement);
    }

    public JsonArrayBuilder withItems(Collection<JsonElement> items) {
        this.items = items;
        return this;
    }

    public JsonArray build() {
        JsonArray jsonArray = new JsonArray();
        for (JsonElement item : this.items) {
            jsonArray.add(item);
        }
        return jsonArray;
    }

    public String buildAsString() {
        return this.build().toString();
    }
}

