/*
 * Decompiled with CFR 0.152.
 */
package seatsio.events;

import com.google.gson.JsonObject;
import java.time.LocalDate;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import seatsio.charts.Category;
import seatsio.charts.CategoryKey;
import seatsio.events.TableBookingConfig;

public abstract class EventParams<T extends EventParams> {
    public String eventKey;
    public String name;
    public LocalDate date;
    public TableBookingConfig tableBookingConfig;
    public Map<String, CategoryKey> objectCategories;
    public List<Category> categories;

    public List<JsonObject> getCategoriesAsJson() {
        if (this.categories == null) {
            return null;
        }
        return this.categories.stream().map(Category::toJson).collect(Collectors.toList());
    }

    public T withKey(String eventKey) {
        this.eventKey = eventKey;
        return (T)this;
    }

    public T withTableBookingConfig(TableBookingConfig tableBookingConfig) {
        this.tableBookingConfig = tableBookingConfig;
        return (T)this;
    }

    public T withObjectCategories(Map<String, CategoryKey> objectCategories) {
        this.objectCategories = objectCategories;
        return (T)this;
    }

    public T withCategories(List<Category> categories) {
        this.categories = categories;
        return (T)this;
    }

    public T withName(String name) {
        this.name = name;
        return (T)this;
    }

    public T withDate(LocalDate date) {
        this.date = date;
        return (T)this;
    }
}

