/*
 * Decompiled with CFR 0.152.
 */
package seatsio.events;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import kong.unirest.HttpRequest;
import kong.unirest.HttpRequestWithBody;
import seatsio.events.Channel;
import seatsio.events.ChannelCreationParams;
import seatsio.json.JsonArrayBuilder;
import seatsio.json.JsonObjectBuilder;
import seatsio.util.UnirestWrapper;

public class Channels {
    private final String baseUrl;
    private final UnirestWrapper unirest;

    public Channels(String baseUrl, UnirestWrapper unirest) {
        this.baseUrl = baseUrl;
        this.unirest = unirest;
    }

    public void add(String eventKey, String channelKey, String name, String color, Integer index, Set<String> objects) {
        this.add(eventKey, List.of(new ChannelCreationParams(channelKey, name, color, index, objects)));
    }

    public void add(String eventKey, Collection<ChannelCreationParams> paramsList) {
        this.unirest.stringResponse((HttpRequest)((HttpRequestWithBody)UnirestWrapper.post(this.baseUrl + "/events/{key}/channels").routeParam("key", eventKey)).body(JsonArrayBuilder.aJsonArray().withItems(paramsList.stream().map(ChannelCreationParams::toJson).collect(Collectors.toList())).buildAsString()));
    }

    public void remove(String eventKey, String channelKey) {
        this.unirest.stringResponse(((HttpRequestWithBody)UnirestWrapper.delete(this.baseUrl + "/events/{eventKey}/channels/{channelKey}").routeParam("eventKey", eventKey)).routeParam("channelKey", channelKey));
    }

    public void update(String eventKey, String channelKey, String name, String color, Set<String> objects) {
        this.unirest.stringResponse((HttpRequest)((HttpRequestWithBody)((HttpRequestWithBody)UnirestWrapper.post(this.baseUrl + "/events/{eventKey}/channels/{channelKey}").routeParam("eventKey", eventKey)).routeParam("channelKey", channelKey)).body(JsonObjectBuilder.aJsonObject().withPropertyIfNotNull("name", name).withPropertyIfNotNull("color", color).withPropertyIfNotNull("objects", objects).buildAsString()));
    }

    public void addObjects(String eventKey, String channelKey, Set<String> objects) {
        this.unirest.stringResponse((HttpRequest)((HttpRequestWithBody)((HttpRequestWithBody)UnirestWrapper.post(this.baseUrl + "/events/{eventKey}/channels/{channelKey}/objects").routeParam("eventKey", eventKey)).routeParam("channelKey", channelKey)).body(JsonObjectBuilder.aJsonObject().withProperty("objects", objects).buildAsString()));
    }

    public void removeObjects(String eventKey, String channelKey, Set<String> objects) {
        this.unirest.stringResponse((HttpRequest)((HttpRequestWithBody)((HttpRequestWithBody)UnirestWrapper.delete(this.baseUrl + "/events/{eventKey}/channels/{channelKey}/objects").routeParam("eventKey", eventKey)).routeParam("channelKey", channelKey)).body(JsonObjectBuilder.aJsonObject().withProperty("objects", objects).buildAsString()));
    }

    public void replace(String eventKey, List<Channel> channels) {
        this.unirest.stringResponse((HttpRequest)((HttpRequestWithBody)UnirestWrapper.post(this.baseUrl + "/events/{key}/channels/replace").routeParam("key", eventKey)).body(Channels.channelsToJson(channels)));
    }

    private static String channelsToJson(List<Channel> channels) {
        JsonArray channelsJson = new JsonArray();
        channels.forEach(channel -> channelsJson.add((JsonElement)channel.toJson()));
        return JsonObjectBuilder.aJsonObject().withProperty("channels", (JsonElement)channelsJson).buildAsString();
    }
}

