/*
 * Decompiled with CFR 0.152.
 */
package seatsio;

import java.nio.charset.StandardCharsets;
import java.util.List;
import java.util.stream.Collectors;
import kong.unirest.HttpRequest;
import kong.unirest.RawResponse;
import seatsio.ApiError;
import seatsio.exceptions.RateLimitExceededException;
import seatsio.json.SeatsioGson;

public class SeatsioException
extends RuntimeException {
    public List<ApiError> errors;
    public String requestId;

    public SeatsioException(String message) {
        super(message);
    }

    public SeatsioException(Throwable t, HttpRequest request) {
        super("Error while executing " + request.getHttpMethod() + " " + request.getUrl(), t);
    }

    protected SeatsioException(List<ApiError> errors, String requestId) {
        super(SeatsioException.exceptionMessage(errors));
        this.errors = errors;
        this.requestId = requestId;
    }

    private SeatsioException(HttpRequest request, RawResponse response) {
        super(SeatsioException.exceptionMessage(request, response));
    }

    public static SeatsioException from(HttpRequest request, RawResponse response, byte[] responseBody) {
        if (response.getHeaders().getFirst("Content-Type").contains("application/json")) {
            SeatsioExceptionTO parsedException = SeatsioException.fromJson(responseBody);
            if (response.getStatus() == 429) {
                return new RateLimitExceededException(parsedException.errors, parsedException.requestId);
            }
            return new SeatsioException(parsedException.errors, parsedException.requestId);
        }
        return new SeatsioException(request, response);
    }

    private static String exceptionMessage(List<ApiError> errors) {
        return errors.stream().map(ApiError::getMessage).collect(Collectors.joining(", "));
    }

    private static String exceptionMessage(HttpRequest request, RawResponse response) {
        return request.getHttpMethod() + " " + request.getUrl() + " resulted in a " + response.getStatus() + " " + response.getStatusText() + " response. Body: " + response.getContentAsString();
    }

    private static SeatsioExceptionTO fromJson(byte[] responseBody) {
        return (SeatsioExceptionTO)SeatsioGson.gson().fromJson(new String(responseBody, StandardCharsets.UTF_8), SeatsioExceptionTO.class);
    }

    private static class SeatsioExceptionTO {
        public List<ApiError> errors;
        public String requestId;

        private SeatsioExceptionTO() {
        }
    }
}

