/*
 * Decompiled with CFR 0.152.
 */
package io.seata.sqlparser.druid;

import com.alibaba.druid.sql.ast.SQLExpr;
import com.alibaba.druid.sql.ast.SQLLimit;
import com.alibaba.druid.sql.ast.SQLOrderBy;
import com.alibaba.druid.sql.ast.SQLStatement;
import com.alibaba.druid.sql.ast.expr.SQLBetweenExpr;
import com.alibaba.druid.sql.ast.expr.SQLBinaryOpExpr;
import com.alibaba.druid.sql.ast.expr.SQLExistsExpr;
import com.alibaba.druid.sql.ast.expr.SQLInListExpr;
import com.alibaba.druid.sql.ast.expr.SQLInSubQueryExpr;
import com.alibaba.druid.sql.ast.statement.SQLInsertStatement;
import com.alibaba.druid.sql.ast.statement.SQLJoinTableSource;
import com.alibaba.druid.sql.ast.statement.SQLMergeStatement;
import com.alibaba.druid.sql.ast.statement.SQLReplaceStatement;
import com.alibaba.druid.sql.ast.statement.SQLSubqueryTableSource;
import com.alibaba.druid.sql.visitor.SQLASTVisitor;
import com.alibaba.druid.sql.visitor.SQLASTVisitorAdapter;
import io.seata.common.exception.NotSupportYetException;
import io.seata.sqlparser.SQLParsingException;
import io.seata.sqlparser.SQLRecognizer;

public abstract class BaseRecognizer
implements SQLRecognizer {
    protected String originalSQL;

    public BaseRecognizer(String originalSQL) {
        this.originalSQL = originalSQL;
    }

    public void executeVisit(SQLExpr where, SQLASTVisitor visitor) {
        if (where instanceof SQLBinaryOpExpr) {
            visitor.visit((SQLBinaryOpExpr)where);
        } else if (where instanceof SQLInListExpr) {
            visitor.visit((SQLInListExpr)where);
        } else if (where instanceof SQLBetweenExpr) {
            visitor.visit((SQLBetweenExpr)where);
        } else if (where instanceof SQLExistsExpr) {
            visitor.visit((SQLExistsExpr)where);
        } else {
            throw new IllegalArgumentException("unexpected WHERE expr: " + where.getClass().getSimpleName());
        }
    }

    protected void wrapSQLParsingException(SQLExpr expr) {
        String errorMsg;
        try {
            errorMsg = "Unknown SQLExpr: " + expr.getClass() + " " + expr;
        }
        catch (Exception e) {
            throw new SQLParsingException("Unknown SQLExpr: " + e.getMessage(), (Throwable)e);
        }
        throw new SQLParsingException(errorMsg);
    }

    public void executeLimit(SQLLimit sqlLimit, SQLASTVisitor visitor) {
        visitor.visit(sqlLimit);
    }

    public void executeOrderBy(SQLOrderBy sqlOrderBy, SQLASTVisitor visitor) {
        visitor.visit(sqlOrderBy);
    }

    public String getOriginalSQL() {
        return this.originalSQL;
    }

    protected abstract SQLStatement getAst();

    public boolean isSqlSyntaxSupports() {
        SQLASTVisitorAdapter visitor = new SQLASTVisitorAdapter(){

            public boolean visit(SQLJoinTableSource x) {
                throw new NotSupportYetException("not support the sql syntax with join table:" + x + "\nplease see the doc about SQL restrictions https://seata.io/zh-cn/docs/user/sqlreference/dml.html");
            }

            public boolean visit(SQLInSubQueryExpr x) {
                throw new NotSupportYetException("not support the sql syntax with InSubQuery:" + x + "\nplease see the doc about SQL restrictions https://seata.io/zh-cn/docs/user/sqlreference/dml.html");
            }

            public boolean visit(SQLSubqueryTableSource x) {
                throw new NotSupportYetException("not support the sql syntax with SubQuery:" + x + "\nplease see the doc about SQL restrictions https://seata.io/zh-cn/docs/user/sqlreference/dml.html");
            }

            public boolean visit(SQLReplaceStatement x) {
                throw new NotSupportYetException("not support the sql syntax with ReplaceStatement:" + x + "\nplease see the doc about SQL restrictions https://seata.io/zh-cn/docs/user/sqlreference/dml.html");
            }

            public boolean visit(SQLMergeStatement x) {
                throw new NotSupportYetException("not support the sql syntax with MergeStatement:" + x + "\nplease see the doc about SQL restrictions https://seata.io/zh-cn/docs/user/sqlreference/dml.html");
            }

            public boolean visit(SQLInsertStatement x) {
                if (null != x.getQuery()) {
                    throw new NotSupportYetException("not support the sql syntax insert with query:" + x + "\nplease see the doc about SQL restrictions https://seata.io/zh-cn/docs/user/sqlreference/dml.html");
                }
                return true;
            }
        };
        this.getAst().accept((SQLASTVisitor)visitor);
        return true;
    }

    public static class VMarker {
        public String toString() {
            return "?";
        }
    }
}

