/*
 * Decompiled with CFR 0.152.
 */
package io.seata.sqlparser.druid.mysql;

import com.alibaba.druid.sql.ast.SQLExpr;
import com.alibaba.druid.sql.ast.SQLStatement;
import com.alibaba.druid.sql.ast.expr.SQLIdentifierExpr;
import com.alibaba.druid.sql.ast.expr.SQLMethodInvokeExpr;
import com.alibaba.druid.sql.ast.expr.SQLNullExpr;
import com.alibaba.druid.sql.ast.expr.SQLValuableExpr;
import com.alibaba.druid.sql.ast.expr.SQLVariantRefExpr;
import com.alibaba.druid.sql.ast.statement.SQLExprTableSource;
import com.alibaba.druid.sql.ast.statement.SQLInsertStatement;
import com.alibaba.druid.sql.dialect.mysql.ast.statement.MySqlInsertStatement;
import com.alibaba.druid.sql.dialect.mysql.visitor.MySqlOutputVisitor;
import io.seata.sqlparser.SQLInsertRecognizer;
import io.seata.sqlparser.SQLParsingException;
import io.seata.sqlparser.SQLType;
import io.seata.sqlparser.druid.mysql.BaseMySQLRecognizer;
import io.seata.sqlparser.struct.Null;
import io.seata.sqlparser.struct.SqlMethodExpr;
import java.util.ArrayList;
import java.util.List;

public class MySQLInsertRecognizer
extends BaseMySQLRecognizer
implements SQLInsertRecognizer {
    private final MySqlInsertStatement ast;

    public MySQLInsertRecognizer(String originalSQL, SQLStatement ast) {
        super(originalSQL);
        this.ast = (MySqlInsertStatement)ast;
    }

    public SQLType getSQLType() {
        return SQLType.INSERT;
    }

    public String getTableAlias() {
        return this.ast.getTableSource().getAlias();
    }

    public String getTableName() {
        StringBuilder sb = new StringBuilder();
        MySqlOutputVisitor visitor = new MySqlOutputVisitor(sb){

            public boolean visit(SQLExprTableSource x) {
                this.printTableSourceExpr(x.getExpr());
                return false;
            }
        };
        visitor.visit(this.ast.getTableSource());
        return sb.toString();
    }

    public List<String> getInsertColumns() {
        List columnSQLExprs = this.ast.getColumns();
        if (columnSQLExprs.isEmpty()) {
            return null;
        }
        ArrayList<String> list = new ArrayList<String>(columnSQLExprs.size());
        for (SQLExpr expr : columnSQLExprs) {
            if (expr instanceof SQLIdentifierExpr) {
                list.add(((SQLIdentifierExpr)expr).getName());
                continue;
            }
            throw new SQLParsingException("Unknown SQLExpr: " + expr.getClass() + " " + expr);
        }
        return list;
    }

    public List<List<Object>> getInsertRows() {
        List valuesClauses = this.ast.getValuesList();
        ArrayList<List<Object>> rows = new ArrayList<List<Object>>(valuesClauses.size());
        for (SQLInsertStatement.ValuesClause valuesClause : valuesClauses) {
            List exprs = valuesClause.getValues();
            ArrayList<Object> row = new ArrayList<Object>(exprs.size());
            rows.add(row);
            for (SQLExpr expr : valuesClause.getValues()) {
                if (expr instanceof SQLNullExpr) {
                    row.add(Null.get());
                    continue;
                }
                if (expr instanceof SQLValuableExpr) {
                    row.add(((SQLValuableExpr)expr).getValue());
                    continue;
                }
                if (expr instanceof SQLVariantRefExpr) {
                    row.add(((SQLVariantRefExpr)expr).getName());
                    continue;
                }
                if (expr instanceof SQLMethodInvokeExpr) {
                    row.add(new SqlMethodExpr());
                    continue;
                }
                throw new SQLParsingException("Unknown SQLExpr: " + expr.getClass() + " " + expr);
            }
        }
        return rows;
    }
}

