/*
 * Decompiled with CFR 0.152.
 */
package io.seata.sqlparser.druid;

import io.seata.common.loader.EnhancedServiceLoader;
import io.seata.sqlparser.druid.SQLOperateRecognizerHolder;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;

public class SQLOperateRecognizerHolderFactory {
    private static final Map<String, SQLOperateRecognizerHolder> RECOGNIZER_HOLDER_MAP = new ConcurrentHashMap<String, SQLOperateRecognizerHolder>();

    public static SQLOperateRecognizerHolder getSQLRecognizerHolder(String dbType) {
        if (RECOGNIZER_HOLDER_MAP.get(dbType) != null) {
            return RECOGNIZER_HOLDER_MAP.get(dbType);
        }
        SQLOperateRecognizerHolder recognizerHolder = (SQLOperateRecognizerHolder)EnhancedServiceLoader.load(SQLOperateRecognizerHolder.class, (String)dbType, (ClassLoader)SQLOperateRecognizerHolderFactory.class.getClassLoader());
        RECOGNIZER_HOLDER_MAP.putIfAbsent(dbType, recognizerHolder);
        return recognizerHolder;
    }
}

