/*
 * Decompiled with CFR 0.152.
 */
package io.seata.sqlparser.struct;

import io.seata.common.exception.NotSupportYetException;
import io.seata.common.util.CollectionUtils;
import io.seata.common.util.LowerCaseLinkHashMap;
import io.seata.sqlparser.struct.ColumnMeta;
import io.seata.sqlparser.struct.IndexMeta;
import io.seata.sqlparser.struct.IndexType;
import io.seata.sqlparser.util.ColumnUtils;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.TreeSet;
import java.util.stream.Collectors;

public class TableMeta {
    private String tableName;
    private boolean isCaseSensitive;
    private final Map<String, ColumnMeta> allColumns = new LowerCaseLinkHashMap();
    private final Map<String, IndexMeta> allIndexes = new LowerCaseLinkHashMap();

    public String getTableName() {
        return this.tableName;
    }

    public void setTableName(String tableName) {
        this.tableName = tableName;
    }

    public ColumnMeta getColumnMeta(String colName) {
        return this.allColumns.get(colName);
    }

    public Map<String, ColumnMeta> getAllColumns() {
        return this.allColumns;
    }

    public Map<String, IndexMeta> getAllIndexes() {
        return this.allIndexes;
    }

    public boolean isCaseSensitive() {
        return this.isCaseSensitive;
    }

    public void setCaseSensitive(boolean caseSensitive) {
        this.isCaseSensitive = caseSensitive;
    }

    public ColumnMeta getAutoIncreaseColumn() {
        for (Map.Entry<String, ColumnMeta> entry : this.allColumns.entrySet()) {
            ColumnMeta col = entry.getValue();
            if (!"YES".equalsIgnoreCase(col.getIsAutoincrement())) continue;
            return col;
        }
        return null;
    }

    public Map<String, ColumnMeta> getPrimaryKeyMap() {
        HashMap<String, ColumnMeta> pk = new HashMap<String, ColumnMeta>();
        this.allIndexes.forEach((key, index) -> {
            if (index.getIndextype().value() == IndexType.PRIMARY.value()) {
                for (ColumnMeta col : index.getValues()) {
                    pk.put(col.getColumnName(), col);
                }
            }
        });
        if (pk.size() < 1) {
            throw new NotSupportYetException(String.format("%s needs to contain the primary key.", this.tableName));
        }
        return pk;
    }

    public Set<String> getCaseInsensitivePKs() {
        TreeSet pks = new TreeSet(String.CASE_INSENSITIVE_ORDER);
        this.allIndexes.forEach((key, index) -> {
            if (index.getIndextype().value() == IndexType.PRIMARY.value()) {
                for (ColumnMeta col : index.getValues()) {
                    pks.add(col.getColumnName());
                }
            }
        });
        if (pks.size() < 1) {
            throw new NotSupportYetException(String.format("%s needs to contain the primary key.", this.tableName));
        }
        return Collections.unmodifiableSet(pks);
    }

    public List<String> getPrimaryKeyOnlyName() {
        ArrayList<String> list = new ArrayList<String>();
        for (Map.Entry<String, ColumnMeta> entry : this.getPrimaryKeyMap().entrySet()) {
            list.add(entry.getKey());
        }
        return list;
    }

    public List<String> getOnUpdateColumnsOnlyName() {
        return this.allColumns.values().stream().filter(ColumnMeta::isOnUpdate).map(ColumnMeta::getColumnName).collect(Collectors.toList());
    }

    public List<String> getEscapePkNameList(String dbType) {
        return ColumnUtils.addEscape(this.getPrimaryKeyOnlyName(), dbType);
    }

    public boolean containsPK(List<String> cols) {
        if (cols == null) {
            return false;
        }
        List<String> pk = this.getPrimaryKeyOnlyName();
        if (pk.isEmpty()) {
            return false;
        }
        if (cols.containsAll(pk)) {
            return true;
        }
        return CollectionUtils.toUpperList(cols).containsAll(CollectionUtils.toUpperList(pk));
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof TableMeta)) {
            return false;
        }
        TableMeta tableMeta = (TableMeta)o;
        if (!Objects.equals(tableMeta.tableName, this.tableName)) {
            return false;
        }
        if (!Objects.equals(tableMeta.allColumns, this.allColumns)) {
            return false;
        }
        return Objects.equals(tableMeta.allIndexes, this.allIndexes);
    }

    public int hashCode() {
        int hash = Objects.hashCode(this.tableName);
        hash += Objects.hashCode(this.allColumns);
        hash += Objects.hashCode(this.allIndexes);
        return hash += Objects.hashCode(this.isCaseSensitive);
    }
}

