/*
 * Decompiled with CFR 0.152.
 */
package io.seata.sqlparser.util;

import io.seata.common.util.CollectionUtils;
import io.seata.common.util.StringUtils;
import io.seata.sqlparser.KeywordChecker;
import io.seata.sqlparser.KeywordCheckerFactory;
import java.util.ArrayList;
import java.util.List;

public final class ColumnUtils {
    private static final String DOT = ".";

    public static List<String> delEscape(List<String> cols, String dbType) {
        List<String> newCols = ColumnUtils.delEscape(cols, Escape.STANDARD);
        if (ColumnUtils.isMysqlSeries(dbType)) {
            newCols = ColumnUtils.delEscape(newCols, Escape.MYSQL);
        }
        return newCols;
    }

    public static List<String> delEscape(List<String> cols, Escape escape) {
        if (CollectionUtils.isEmpty(cols)) {
            return cols;
        }
        ArrayList<String> newCols = new ArrayList<String>(cols.size());
        int len = cols.size();
        for (int i = 0; i < len; ++i) {
            String col = cols.get(i);
            col = ColumnUtils.delEscape(col, escape);
            newCols.add(col);
        }
        return newCols;
    }

    public static String delEscape(String colName, String dbType) {
        String newColName = ColumnUtils.delEscape(colName, Escape.STANDARD);
        if (ColumnUtils.isMysqlSeries(dbType)) {
            newColName = ColumnUtils.delEscape(newColName, Escape.MYSQL);
        }
        return newColName;
    }

    public static String delEscape(String colName, Escape escape) {
        if (colName == null || colName.isEmpty()) {
            return colName;
        }
        if (colName.charAt(0) == escape.value && colName.charAt(colName.length() - 1) == escape.value) {
            String str = escape.value + DOT + escape.value;
            int index = colName.indexOf(str);
            if (index > -1) {
                return colName.substring(1, index) + DOT + colName.substring(index + str.length(), colName.length() - 1);
            }
            return colName.substring(1, colName.length() - 1);
        }
        String str = escape.value + DOT;
        int index = colName.indexOf(str);
        if (index > -1 && colName.charAt(0) == escape.value) {
            return colName.substring(1, index) + DOT + colName.substring(index + str.length());
        }
        str = DOT + escape.value;
        index = colName.indexOf(str);
        if (index > -1 && colName.charAt(colName.length() - 1) == escape.value) {
            return colName.substring(0, index) + DOT + colName.substring(index + str.length(), colName.length() - 1);
        }
        return colName;
    }

    public static List<String> addEscape(List<String> cols, String dbType) {
        if (CollectionUtils.isEmpty(cols)) {
            return cols;
        }
        ArrayList<String> newCols = new ArrayList<String>(cols.size());
        int len = cols.size();
        for (int i = 0; i < len; ++i) {
            String col = cols.get(i);
            col = ColumnUtils.addEscape(col, dbType);
            newCols.add(col);
        }
        return newCols;
    }

    public static String addEscape(String colName, String dbType) {
        if (ColumnUtils.isMysqlSeries(dbType)) {
            return ColumnUtils.addEscape(colName, dbType, Escape.MYSQL);
        }
        return ColumnUtils.addEscape(colName, dbType, Escape.STANDARD);
    }

    private static String addEscape(String colName, String dbType, Escape escape) {
        boolean check;
        if (colName == null || colName.isEmpty()) {
            return colName;
        }
        if (colName.charAt(0) == escape.value && colName.charAt(colName.length() - 1) == escape.value) {
            return colName;
        }
        KeywordChecker keywordChecker = KeywordCheckerFactory.getKeywordChecker(dbType);
        if (keywordChecker != null && !(check = keywordChecker.checkEscape(colName))) {
            return colName;
        }
        if (colName.contains(DOT)) {
            String str = escape.value + DOT;
            int dotIndex = colName.indexOf(str);
            if (dotIndex > -1) {
                return colName.substring(0, dotIndex + str.length()) + escape.value + colName.substring(dotIndex + str.length()) + escape.value;
            }
            str = DOT + escape.value;
            dotIndex = colName.indexOf(str);
            if (dotIndex > -1) {
                return escape.value + colName.substring(0, dotIndex) + escape.value + colName.substring(dotIndex);
            }
            str = DOT;
            dotIndex = colName.indexOf(str);
            if (dotIndex > -1) {
                return escape.value + colName.substring(0, dotIndex) + escape.value + DOT + escape.value + colName.substring(dotIndex + str.length()) + escape.value;
            }
        }
        char[] buf = new char[colName.length() + 2];
        buf[0] = escape.value;
        buf[buf.length - 1] = escape.value;
        colName.getChars(0, colName.length(), buf, 1);
        return new String(buf).intern();
    }

    private static boolean isMysqlSeries(String dbType) {
        return StringUtils.equalsIgnoreCase((String)dbType, (String)"mysql") || StringUtils.equalsIgnoreCase((String)dbType, (String)"h2") || StringUtils.equalsIgnoreCase((String)dbType, (String)"mariadb");
    }

    public static enum Escape {
        STANDARD('\"'),
        MYSQL('`');

        public final char value;

        private Escape(char value) {
            this.value = value;
        }
    }
}

