/*
 * Decompiled with CFR 0.152.
 */
package io.seata.sqlparser.antlr.mysql;

import io.seata.sqlparser.SQLInsertRecognizer;
import io.seata.sqlparser.SQLType;
import io.seata.sqlparser.antlr.mysql.MySqlContext;
import io.seata.sqlparser.antlr.mysql.parser.MySqlLexer;
import io.seata.sqlparser.antlr.mysql.parser.MySqlParser;
import io.seata.sqlparser.antlr.mysql.stream.ANTLRNoCaseStringStream;
import io.seata.sqlparser.antlr.mysql.visit.InsertStatementSqlVisitor;
import io.seata.sqlparser.util.ColumnUtils;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.stream.Collectors;
import org.antlr.v4.runtime.CharStream;
import org.antlr.v4.runtime.CommonTokenStream;
import org.antlr.v4.runtime.TokenSource;
import org.antlr.v4.runtime.TokenStream;
import org.antlr.v4.runtime.tree.ParseTree;

public class AntlrMySQLInsertRecognizer
implements SQLInsertRecognizer {
    private MySqlContext sqlContext;

    public AntlrMySQLInsertRecognizer(String sql) {
        MySqlLexer lexer = new MySqlLexer((CharStream)new ANTLRNoCaseStringStream(sql));
        CommonTokenStream tokenStream = new CommonTokenStream((TokenSource)lexer);
        MySqlParser parser = new MySqlParser((TokenStream)tokenStream);
        MySqlParser.RootContext rootContext = parser.root();
        this.sqlContext = new MySqlContext();
        this.sqlContext.setOriginalSQL(sql);
        InsertStatementSqlVisitor visitor = new InsertStatementSqlVisitor(this.sqlContext);
        visitor.visit((ParseTree)rootContext);
    }

    public SQLType getSQLType() {
        return SQLType.INSERT;
    }

    public String getTableAlias() {
        return this.sqlContext.tableAlias;
    }

    public String getTableName() {
        return this.sqlContext.tableName;
    }

    public String getOriginalSQL() {
        return this.sqlContext.getOriginalSQL();
    }

    public boolean insertColumnsIsEmpty() {
        List<MySqlContext.SQL> insertColumnNames = this.sqlContext.getInsertColumnNames();
        return insertColumnNames.isEmpty();
    }

    public List<String> getInsertColumns() {
        List<MySqlContext.SQL> insertColumnNames = this.sqlContext.getInsertColumnNames();
        if (insertColumnNames.isEmpty()) {
            return new ArrayList<String>();
        }
        return insertColumnNames.stream().map(insertColumns -> insertColumns.getColumnName()).collect(Collectors.toList());
    }

    public List<List<Object>> getInsertRows(Collection<Integer> primaryKeyIndex) {
        return null;
    }

    public List<String> getInsertParamsValue() {
        return null;
    }

    public List<String> getDuplicateKeyUpdate() {
        return null;
    }

    public List<String> getInsertColumnsUnEscape() {
        List<String> insertColumns = this.getInsertColumns();
        return ColumnUtils.delEscape(insertColumns, (String)"mysql");
    }
}

