/*
 * Decompiled with CFR 0.152.
 */
package io.seata.sqlparser.antlr.mysql;

import io.seata.sqlparser.ParametersHolder;
import io.seata.sqlparser.SQLType;
import io.seata.sqlparser.SQLUpdateRecognizer;
import io.seata.sqlparser.antlr.mysql.MySqlContext;
import io.seata.sqlparser.antlr.mysql.listener.UpdateSpecificationSqlListener;
import io.seata.sqlparser.antlr.mysql.parser.MySqlLexer;
import io.seata.sqlparser.antlr.mysql.parser.MySqlParser;
import io.seata.sqlparser.antlr.mysql.stream.ANTLRNoCaseStringStream;
import io.seata.sqlparser.util.ColumnUtils;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;
import org.antlr.v4.runtime.CharStream;
import org.antlr.v4.runtime.CommonTokenStream;
import org.antlr.v4.runtime.TokenSource;
import org.antlr.v4.runtime.TokenStream;
import org.antlr.v4.runtime.tree.ParseTree;
import org.antlr.v4.runtime.tree.ParseTreeListener;
import org.antlr.v4.runtime.tree.ParseTreeWalker;

public class AntlrMySQLUpdateRecognizer
implements SQLUpdateRecognizer {
    private MySqlContext sqlContext;

    public AntlrMySQLUpdateRecognizer(String sql) {
        MySqlLexer mySqlLexer = new MySqlLexer((CharStream)new ANTLRNoCaseStringStream(sql));
        CommonTokenStream commonTokenStream = new CommonTokenStream((TokenSource)mySqlLexer);
        MySqlParser parser2 = new MySqlParser((TokenStream)commonTokenStream);
        MySqlParser.RootContext root = parser2.root();
        ParseTreeWalker walker2 = new ParseTreeWalker();
        this.sqlContext = new MySqlContext();
        this.sqlContext.setOriginalSQL(sql);
        walker2.walk((ParseTreeListener)new UpdateSpecificationSqlListener(this.sqlContext), (ParseTree)root);
    }

    public List<String> getUpdateColumns() {
        List<MySqlContext.SQL> updateFoColumnNames = this.sqlContext.getUpdateFoColumnNames();
        ArrayList<String> sqlList = new ArrayList<String>();
        for (MySqlContext.SQL sql : updateFoColumnNames) {
            sqlList.add(sql.getUpdateColumn());
        }
        return sqlList;
    }

    public List<Object> getUpdateValues() {
        List<MySqlContext.SQL> updateForValues = this.sqlContext.getUpdateForValues();
        if (updateForValues.isEmpty()) {
            return new ArrayList<Object>();
        }
        return updateForValues.stream().map(updateValues -> updateValues.getUpdateValue()).collect(Collectors.toList());
    }

    public List<String> getUpdateColumnsUnEscape() {
        List<String> updateColumns = this.getUpdateColumns();
        return ColumnUtils.delEscape(updateColumns, (String)"mysql");
    }

    public String getWhereCondition(ParametersHolder parametersHolder, ArrayList<List<Object>> paramAppenderList) {
        return this.sqlContext.getWhereCondition();
    }

    public String getWhereCondition() {
        return this.sqlContext.getWhereCondition();
    }

    public String getLimitCondition() {
        return null;
    }

    public String getLimitCondition(ParametersHolder parametersHolder, ArrayList<List<Object>> paramAppenderList) {
        return null;
    }

    public String getOrderByCondition() {
        return null;
    }

    public String getOrderByCondition(ParametersHolder parametersHolder, ArrayList<List<Object>> paramAppenderList) {
        return null;
    }

    public SQLType getSQLType() {
        return SQLType.UPDATE;
    }

    public String getTableAlias() {
        return this.sqlContext.tableAlias;
    }

    public String getTableName() {
        return this.sqlContext.tableName;
    }

    public String getOriginalSQL() {
        return this.sqlContext.getOriginalSQL();
    }
}

