/*
 * Decompiled with CFR 0.152.
 */
package io.seata.server.store;

import io.seata.core.model.GlobalStatus;
import io.seata.server.session.GlobalSession;
import io.seata.server.session.SessionCondition;
import io.seata.server.store.SessionStorable;
import java.util.List;

public interface TransactionStoreManager {
    public boolean writeSession(LogOperation var1, SessionStorable var2);

    public GlobalSession readSession(String var1);

    public GlobalSession readSession(String var1, boolean var2);

    public List<GlobalSession> readSession(GlobalStatus[] var1, boolean var2);

    public List<GlobalSession> readSession(SessionCondition var1);

    public void shutdown();

    public static enum LogOperation {
        GLOBAL_ADD(1),
        GLOBAL_UPDATE(2),
        GLOBAL_REMOVE(3),
        BRANCH_ADD(4),
        BRANCH_UPDATE(5),
        BRANCH_REMOVE(6);

        private byte code;

        private LogOperation(byte code) {
            this.code = code;
        }

        public byte getCode() {
            return this.code;
        }

        public static LogOperation getLogOperationByCode(byte code) {
            for (LogOperation temp : LogOperation.values()) {
                if (temp.getCode() != code) continue;
                return temp;
            }
            throw new IllegalArgumentException("Unknown LogOperation[" + code + "]");
        }
    }
}

