/*
 * Decompiled with CFR 0.152.
 */
package io.seata.server.storage.db.lock;

import io.seata.common.exception.ShouldNeverHappenException;
import io.seata.common.loader.EnhancedServiceLoader;
import io.seata.common.loader.LoadLevel;
import io.seata.common.loader.Scope;
import io.seata.common.util.IOUtil;
import io.seata.common.util.StringUtils;
import io.seata.config.Configuration;
import io.seata.config.ConfigurationCache;
import io.seata.config.ConfigurationChangeEvent;
import io.seata.config.ConfigurationChangeListener;
import io.seata.config.ConfigurationFactory;
import io.seata.core.store.DistributedLockDO;
import io.seata.core.store.DistributedLocker;
import io.seata.core.store.db.DataSourceProvider;
import io.seata.core.store.db.sql.distributed.lock.DistributedLockSqlFactory;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.Objects;
import javax.sql.DataSource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@LoadLevel(name="db", scope=Scope.SINGLETON)
public class DataBaseDistributedLocker
implements DistributedLocker {
    private static final Logger LOGGER = LoggerFactory.getLogger(DataBaseDistributedLocker.class);
    private final String dbType;
    private final String datasourceType;
    private volatile String distributedLockTable;
    private DataSource distributedLockDataSource;
    @Deprecated
    private volatile boolean demotion;

    public DataBaseDistributedLocker() {
        Configuration configuration = ConfigurationFactory.getInstance();
        this.distributedLockTable = configuration.getConfig("store.db.distributedLockTable");
        this.dbType = configuration.getConfig("store.db.dbType");
        this.datasourceType = configuration.getConfig("store.db.datasource");
        if (StringUtils.isBlank((String)this.distributedLockTable)) {
            this.demotion = true;
            ConfigurationCache.addConfigListener((String)"store.db.distributedLockTable", (ConfigurationChangeListener[])new ConfigurationChangeListener[]{new ConfigurationChangeListener(){

                public void onChangeEvent(ConfigurationChangeEvent event) {
                    String newValue = event.getNewValue();
                    if (StringUtils.isNotBlank((String)newValue)) {
                        DataBaseDistributedLocker.this.distributedLockTable = newValue;
                        DataBaseDistributedLocker.this.init();
                        DataBaseDistributedLocker.this.demotion = false;
                        ConfigurationCache.removeConfigListener((String)"store.db.distributedLockTable", (ConfigurationChangeListener[])new ConfigurationChangeListener[]{this});
                    }
                }
            }});
            LOGGER.error("The distribute lock table is not config, please create the target table and config it");
            return;
        }
        this.init();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public boolean acquireLock(DistributedLockDO distributedLockDO) {
        if (this.demotion) {
            return true;
        }
        Connection connection = null;
        boolean originalAutoCommit = false;
        try {
            connection = this.distributedLockDataSource.getConnection();
            originalAutoCommit = connection.getAutoCommit();
            connection.setAutoCommit(false);
            DistributedLockDO distributedLockDOFromDB = this.getDistributedLockDO(connection, distributedLockDO.getLockKey());
            if (null == distributedLockDOFromDB) {
                boolean ret = this.insertDistribute(connection, distributedLockDO);
                connection.commit();
                boolean bl = ret;
                return bl;
            }
            if (distributedLockDOFromDB.getExpireTime() >= System.currentTimeMillis()) {
                LOGGER.debug("the distribute lock for key :{} is holding by :{}, acquire lock failure.", (Object)distributedLockDO.getLockKey(), (Object)distributedLockDOFromDB.getLockValue());
                connection.commit();
                boolean ret = false;
                return ret;
            }
            boolean ret = this.updateDistributedLock(connection, distributedLockDO);
            connection.commit();
            boolean bl = ret;
            return bl;
        }
        catch (SQLException ex) {
            LOGGER.error("execute acquire lock failure, key is: {}", (Object)distributedLockDO.getLockKey(), (Object)ex);
            try {
                if (connection != null) {
                    connection.rollback();
                }
            }
            catch (SQLException e) {
                LOGGER.warn("rollback fail because of {}", (Object)e.getMessage(), (Object)e);
            }
            boolean bl = false;
            return bl;
        }
        finally {
            try {
                if (originalAutoCommit) {
                    connection.setAutoCommit(true);
                }
                IOUtil.close((AutoCloseable)connection);
            }
            catch (SQLException sQLException) {}
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean releaseLock(DistributedLockDO distributedLockDO) {
        boolean bl;
        if (this.demotion) {
            return true;
        }
        Connection connection = null;
        boolean originalAutoCommit = false;
        try {
            connection = this.distributedLockDataSource.getConnection();
            originalAutoCommit = connection.getAutoCommit();
            connection.setAutoCommit(false);
            DistributedLockDO distributedLockDOFromDB = this.getDistributedLockDO(connection, distributedLockDO.getLockKey());
            if (null == distributedLockDOFromDB) {
                throw new ShouldNeverHappenException("distributedLockDO would not be null when release distribute lock");
            }
            if (distributedLockDOFromDB.getExpireTime() >= System.currentTimeMillis() && !Objects.equals(distributedLockDOFromDB.getLockValue(), distributedLockDO.getLockValue())) {
                LOGGER.debug("the distribute lock for key :{} is holding by :{}, skip the release lock.", (Object)distributedLockDO.getLockKey(), (Object)distributedLockDOFromDB.getLockValue());
                connection.commit();
                boolean bl2 = true;
                return bl2;
            }
            distributedLockDO.setLockValue(" ");
            distributedLockDO.setExpireTime(Long.valueOf(0L));
            boolean ret = this.updateDistributedLock(connection, distributedLockDO);
            connection.commit();
            bl = ret;
        }
        catch (SQLException ex) {
            LOGGER.error("execute release lock failure, key is: {}", (Object)distributedLockDO.getLockKey(), (Object)ex);
            try {
                if (connection != null) {
                    connection.rollback();
                }
            }
            catch (SQLException e) {
                LOGGER.warn("rollback fail because of {}", (Object)e.getMessage(), (Object)e);
            }
            boolean bl3 = false;
            return bl3;
        }
        finally {
            try {
                if (originalAutoCommit) {
                    connection.setAutoCommit(true);
                }
                IOUtil.close((AutoCloseable)connection);
            }
            catch (SQLException sQLException) {}
        }
        return bl;
    }

    protected DistributedLockDO getDistributedLockDO(Connection connection, String key) throws SQLException {
        try (PreparedStatement pst = connection.prepareStatement(DistributedLockSqlFactory.getDistributedLogStoreSql((String)this.dbType).getSelectDistributeForUpdateSql(this.distributedLockTable));){
            pst.setString(1, key);
            ResultSet resultSet = pst.executeQuery();
            if (resultSet.next()) {
                DistributedLockDO distributedLock = new DistributedLockDO();
                distributedLock.setExpireTime(Long.valueOf(resultSet.getLong("expire")));
                distributedLock.setLockValue(resultSet.getString("lock_value"));
                distributedLock.setLockKey(key);
                DistributedLockDO distributedLockDO = distributedLock;
                return distributedLockDO;
            }
            DistributedLockDO distributedLockDO = null;
            return distributedLockDO;
        }
    }

    protected boolean insertDistribute(Connection connection, DistributedLockDO distributedLockDO) throws SQLException {
        try (PreparedStatement insertPst = connection.prepareStatement(DistributedLockSqlFactory.getDistributedLogStoreSql((String)this.dbType).getInsertSql(this.distributedLockTable));){
            insertPst.setString(1, distributedLockDO.getLockKey());
            insertPst.setString(2, distributedLockDO.getLockValue());
            if (distributedLockDO.getExpireTime() > 0L) {
                distributedLockDO.setExpireTime(Long.valueOf(distributedLockDO.getExpireTime() + System.currentTimeMillis()));
            }
            insertPst.setLong(3, distributedLockDO.getExpireTime());
            boolean bl = insertPst.executeUpdate() > 0;
            return bl;
        }
    }

    protected boolean updateDistributedLock(Connection connection, DistributedLockDO distributedLockDO) throws SQLException {
        try (PreparedStatement updatePst = connection.prepareStatement(DistributedLockSqlFactory.getDistributedLogStoreSql((String)this.dbType).getUpdateSql(this.distributedLockTable));){
            updatePst.setString(1, distributedLockDO.getLockValue());
            if (distributedLockDO.getExpireTime() > 0L) {
                distributedLockDO.setExpireTime(Long.valueOf(distributedLockDO.getExpireTime() + System.currentTimeMillis()));
            }
            updatePst.setLong(2, distributedLockDO.getExpireTime());
            updatePst.setString(3, distributedLockDO.getLockKey());
            boolean bl = updatePst.executeUpdate() > 0;
            return bl;
        }
    }

    private void init() {
        this.distributedLockDataSource = ((DataSourceProvider)EnhancedServiceLoader.load(DataSourceProvider.class, (String)this.datasourceType)).provide();
    }
}

