/*
 * Decompiled with CFR 0.152.
 */
package io.seata.server.session;

import io.seata.common.XID;
import io.seata.common.exception.ShouldNeverHappenException;
import io.seata.common.exception.StoreException;
import io.seata.common.loader.EnhancedServiceLoader;
import io.seata.common.util.CollectionUtils;
import io.seata.common.util.StringUtils;
import io.seata.config.Configuration;
import io.seata.config.ConfigurationFactory;
import io.seata.core.exception.TransactionException;
import io.seata.core.model.GlobalStatus;
import io.seata.core.model.LockStatus;
import io.seata.core.store.DistributedLockDO;
import io.seata.core.store.DistributedLocker;
import io.seata.core.store.StoreMode;
import io.seata.server.lock.distributed.DistributedLockerFactory;
import io.seata.server.session.BranchSession;
import io.seata.server.session.GlobalSession;
import io.seata.server.session.Reloadable;
import io.seata.server.session.SessionCondition;
import io.seata.server.session.SessionManager;
import java.util.Collection;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SessionHolder {
    private static final Logger LOGGER = LoggerFactory.getLogger(SessionHolder.class);
    protected static final Configuration CONFIG = ConfigurationFactory.getInstance();
    public static final String ROOT_SESSION_MANAGER_NAME = "root.data";
    public static final String ASYNC_COMMITTING_SESSION_MANAGER_NAME = "async.commit.data";
    public static final String RETRY_COMMITTING_SESSION_MANAGER_NAME = "retry.commit.data";
    public static final String RETRY_ROLLBACKING_SESSION_MANAGER_NAME = "retry.rollback.data";
    public static final String DEFAULT_SESSION_STORE_FILE_DIR = "sessionStore";
    private static long DISTRIBUTED_LOCK_EXPIRE_TIME = CONFIG.getLong("server.distributedLockExpireTime", 10000L);
    private static SessionManager ROOT_SESSION_MANAGER;
    private static SessionManager ASYNC_COMMITTING_SESSION_MANAGER;
    private static SessionManager RETRY_COMMITTING_SESSION_MANAGER;
    private static SessionManager RETRY_ROLLBACKING_SESSION_MANAGER;
    private static DistributedLocker DISTRIBUTED_LOCKER;

    public static void init(String mode) {
        StoreMode storeMode;
        if (StringUtils.isBlank((String)mode)) {
            mode = CONFIG.getConfig("store.session.mode", CONFIG.getConfig("store.mode", "file"));
        }
        if (StoreMode.DB.equals((Object)(storeMode = StoreMode.get((String)mode)))) {
            ROOT_SESSION_MANAGER = (SessionManager)EnhancedServiceLoader.load(SessionManager.class, (String)StoreMode.DB.getName());
            ASYNC_COMMITTING_SESSION_MANAGER = (SessionManager)EnhancedServiceLoader.load(SessionManager.class, (String)StoreMode.DB.getName(), (Object[])new Object[]{ASYNC_COMMITTING_SESSION_MANAGER_NAME});
            RETRY_COMMITTING_SESSION_MANAGER = (SessionManager)EnhancedServiceLoader.load(SessionManager.class, (String)StoreMode.DB.getName(), (Object[])new Object[]{RETRY_COMMITTING_SESSION_MANAGER_NAME});
            RETRY_ROLLBACKING_SESSION_MANAGER = (SessionManager)EnhancedServiceLoader.load(SessionManager.class, (String)StoreMode.DB.getName(), (Object[])new Object[]{RETRY_ROLLBACKING_SESSION_MANAGER_NAME});
            DISTRIBUTED_LOCKER = DistributedLockerFactory.getDistributedLocker(StoreMode.DB.getName());
        } else if (StoreMode.FILE.equals((Object)storeMode)) {
            String sessionStorePath = CONFIG.getConfig("store.file.dir", DEFAULT_SESSION_STORE_FILE_DIR);
            if (StringUtils.isBlank((String)sessionStorePath)) {
                throw new StoreException("the {store.file.dir} is empty.");
            }
            ASYNC_COMMITTING_SESSION_MANAGER = ROOT_SESSION_MANAGER = (SessionManager)EnhancedServiceLoader.load(SessionManager.class, (String)StoreMode.FILE.getName(), (Object[])new Object[]{ROOT_SESSION_MANAGER_NAME, sessionStorePath});
            RETRY_COMMITTING_SESSION_MANAGER = ROOT_SESSION_MANAGER;
            RETRY_ROLLBACKING_SESSION_MANAGER = ROOT_SESSION_MANAGER;
            DISTRIBUTED_LOCKER = DistributedLockerFactory.getDistributedLocker(StoreMode.FILE.getName());
        } else if (StoreMode.REDIS.equals((Object)storeMode)) {
            ROOT_SESSION_MANAGER = (SessionManager)EnhancedServiceLoader.load(SessionManager.class, (String)StoreMode.REDIS.getName());
            ASYNC_COMMITTING_SESSION_MANAGER = (SessionManager)EnhancedServiceLoader.load(SessionManager.class, (String)StoreMode.REDIS.getName(), (Object[])new Object[]{ASYNC_COMMITTING_SESSION_MANAGER_NAME});
            RETRY_COMMITTING_SESSION_MANAGER = (SessionManager)EnhancedServiceLoader.load(SessionManager.class, (String)StoreMode.REDIS.getName(), (Object[])new Object[]{RETRY_COMMITTING_SESSION_MANAGER_NAME});
            RETRY_ROLLBACKING_SESSION_MANAGER = (SessionManager)EnhancedServiceLoader.load(SessionManager.class, (String)StoreMode.REDIS.getName(), (Object[])new Object[]{RETRY_ROLLBACKING_SESSION_MANAGER_NAME});
            DISTRIBUTED_LOCKER = DistributedLockerFactory.getDistributedLocker(StoreMode.REDIS.getName());
        } else {
            throw new IllegalArgumentException("unknown store mode:" + mode);
        }
        SessionHolder.reload(storeMode);
    }

    protected static void reload(StoreMode storeMode) {
        if (ROOT_SESSION_MANAGER instanceof Reloadable) {
            ((Reloadable)((Object)ROOT_SESSION_MANAGER)).reload();
        }
        if (storeMode == StoreMode.FILE) {
            Collection<GlobalSession> allSessions = ROOT_SESSION_MANAGER.allSessions();
            if (CollectionUtils.isNotEmpty(allSessions)) {
                block9: for (GlobalSession globalSession : allSessions) {
                    GlobalStatus globalStatus = globalSession.getStatus();
                    switch (globalStatus) {
                        case UnKnown: 
                        case Committed: 
                        case CommitFailed: 
                        case Rollbacked: 
                        case RollbackFailed: 
                        case TimeoutRollbacked: 
                        case TimeoutRollbackFailed: 
                        case Finished: {
                            SessionHolder.removeInErrorState(globalSession);
                            continue block9;
                        }
                        case AsyncCommitting: {
                            SessionHolder.queueToAsyncCommitting(globalSession);
                            continue block9;
                        }
                        case Committing: 
                        case CommitRetrying: {
                            SessionHolder.queueToRetryCommit(globalSession);
                            continue block9;
                        }
                    }
                    SessionHolder.lockBranchSessions(globalSession.getSortedBranches());
                    switch (globalStatus) {
                        case Rollbacking: 
                        case RollbackRetrying: 
                        case TimeoutRollbacking: 
                        case TimeoutRollbackRetrying: {
                            globalSession.getBranchSessions().parallelStream().forEach(branchSession -> branchSession.setLockStatus(LockStatus.Rollbacking));
                            SessionHolder.queueToRetryRollback(globalSession);
                            continue block9;
                        }
                        case Begin: {
                            globalSession.setActive(true);
                            continue block9;
                        }
                    }
                    LOGGER.error("Could not handle the global session, xid: {}", (Object)globalSession.getXid());
                    throw new ShouldNeverHappenException("NOT properly handled " + globalStatus);
                }
            }
        } else {
            CompletableFuture.runAsync(() -> {
                SessionCondition searchCondition = new SessionCondition(GlobalStatus.UnKnown, GlobalStatus.Committed, GlobalStatus.Rollbacked, GlobalStatus.TimeoutRollbacked, GlobalStatus.Finished);
                searchCondition.setLazyLoadBranch(true);
                long now = System.currentTimeMillis();
                List<GlobalSession> errorStatusGlobalSessions = ROOT_SESSION_MANAGER.findGlobalSessions(searchCondition);
                while (!CollectionUtils.isEmpty(errorStatusGlobalSessions)) {
                    for (GlobalSession errorStatusGlobalSession : errorStatusGlobalSessions) {
                        if (errorStatusGlobalSession.getBeginTime() >= now) {
                            return;
                        }
                        SessionHolder.removeInErrorState(errorStatusGlobalSession);
                    }
                    errorStatusGlobalSessions = ROOT_SESSION_MANAGER.findGlobalSessions(searchCondition);
                }
            });
        }
    }

    private static void removeInErrorState(GlobalSession globalSession) {
        try {
            LOGGER.warn("The global session should NOT be {}, remove it. xid = {}", (Object)globalSession.getStatus(), (Object)globalSession.getXid());
            ROOT_SESSION_MANAGER.removeGlobalSession(globalSession);
            if (LOGGER.isInfoEnabled()) {
                LOGGER.info("Remove global session succeed, xid = {}, status = {}", (Object)globalSession.getXid(), (Object)globalSession.getStatus());
            }
        }
        catch (Exception e) {
            LOGGER.error("Remove global session failed, xid = {}, status = {}", new Object[]{globalSession.getXid(), globalSession.getStatus(), e});
        }
    }

    private static void queueToAsyncCommitting(GlobalSession globalSession) {
        try {
            globalSession.addSessionLifecycleListener(SessionHolder.getAsyncCommittingSessionManager());
            SessionHolder.getAsyncCommittingSessionManager().addGlobalSession(globalSession);
        }
        catch (TransactionException e) {
            throw new ShouldNeverHappenException((Throwable)e);
        }
    }

    private static void lockBranchSessions(List<BranchSession> branchSessions) {
        branchSessions.forEach(branchSession -> {
            try {
                branchSession.lock();
            }
            catch (TransactionException e) {
                throw new ShouldNeverHappenException((Throwable)e);
            }
        });
    }

    private static void queueToRetryCommit(GlobalSession globalSession) {
        try {
            globalSession.addSessionLifecycleListener(SessionHolder.getRetryCommittingSessionManager());
            SessionHolder.getRetryCommittingSessionManager().addGlobalSession(globalSession);
        }
        catch (TransactionException e) {
            throw new ShouldNeverHappenException((Throwable)e);
        }
    }

    private static void queueToRetryRollback(GlobalSession globalSession) {
        try {
            globalSession.addSessionLifecycleListener(SessionHolder.getRetryRollbackingSessionManager());
            SessionHolder.getRetryRollbackingSessionManager().addGlobalSession(globalSession);
        }
        catch (TransactionException e) {
            throw new ShouldNeverHappenException((Throwable)e);
        }
    }

    public static SessionManager getRootSessionManager() {
        if (ROOT_SESSION_MANAGER == null) {
            throw new ShouldNeverHappenException("SessionManager is NOT init!");
        }
        return ROOT_SESSION_MANAGER;
    }

    @Deprecated
    public static SessionManager getAsyncCommittingSessionManager() {
        if (ASYNC_COMMITTING_SESSION_MANAGER == null) {
            throw new ShouldNeverHappenException("SessionManager is NOT init!");
        }
        return ASYNC_COMMITTING_SESSION_MANAGER;
    }

    @Deprecated
    public static SessionManager getRetryCommittingSessionManager() {
        if (RETRY_COMMITTING_SESSION_MANAGER == null) {
            throw new ShouldNeverHappenException("SessionManager is NOT init!");
        }
        return RETRY_COMMITTING_SESSION_MANAGER;
    }

    @Deprecated
    public static SessionManager getRetryRollbackingSessionManager() {
        if (RETRY_ROLLBACKING_SESSION_MANAGER == null) {
            throw new ShouldNeverHappenException("SessionManager is NOT init!");
        }
        return RETRY_ROLLBACKING_SESSION_MANAGER;
    }

    public static GlobalSession findGlobalSession(String xid) {
        return SessionHolder.findGlobalSession(xid, true);
    }

    public static GlobalSession findGlobalSession(String xid, boolean withBranchSessions) {
        return SessionHolder.getRootSessionManager().findGlobalSession(xid, withBranchSessions);
    }

    public static <T> T lockAndExecute(GlobalSession globalSession, GlobalSession.LockCallable<T> lockCallable) throws TransactionException {
        return SessionHolder.getRootSessionManager().lockAndExecute(globalSession, lockCallable);
    }

    public static boolean acquireDistributedLock(String lockKey) {
        return DISTRIBUTED_LOCKER.acquireLock(new DistributedLockDO(lockKey, XID.getIpAddressAndPort(), Long.valueOf(DISTRIBUTED_LOCK_EXPIRE_TIME)));
    }

    public static boolean releaseDistributedLock(String lockKey) {
        return DISTRIBUTED_LOCKER.releaseLock(new DistributedLockDO(lockKey, XID.getIpAddressAndPort(), Long.valueOf(DISTRIBUTED_LOCK_EXPIRE_TIME)));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean distributedLockAndExecute(String key, NoArgsFunc func) {
        boolean lock = false;
        try {
            lock = SessionHolder.acquireDistributedLock(key);
            if (lock) {
                func.call();
            }
        }
        catch (Exception e) {
            LOGGER.info("Exception running function with key = {}", (Object)key, (Object)e);
        }
        finally {
            if (lock) {
                try {
                    SessionHolder.releaseDistributedLock(key);
                }
                catch (Exception ex) {
                    LOGGER.warn("release distribute lock failure, message = {}", (Object)ex.getMessage(), (Object)ex);
                }
            }
        }
        return lock;
    }

    public static void destroy() {
        if (ROOT_SESSION_MANAGER != null) {
            ROOT_SESSION_MANAGER.destroy();
        }
    }

    @FunctionalInterface
    public static interface NoArgsFunc {
        public void call();
    }
}

