/*
 * Decompiled with CFR 0.152.
 */
package io.seata.server.session;

import io.seata.common.XID;
import io.seata.common.util.StringUtils;
import io.seata.config.ConfigurationFactory;
import io.seata.core.exception.GlobalTransactionException;
import io.seata.core.exception.TransactionException;
import io.seata.core.exception.TransactionExceptionCode;
import io.seata.core.model.BranchStatus;
import io.seata.core.model.BranchType;
import io.seata.core.model.GlobalStatus;
import io.seata.core.model.LockStatus;
import io.seata.server.UUIDGenerator;
import io.seata.server.lock.LockerManagerFactory;
import io.seata.server.session.BranchSession;
import io.seata.server.session.SessionHolder;
import io.seata.server.session.SessionLifecycle;
import io.seata.server.session.SessionLifecycleListener;
import io.seata.server.session.SessionStatusValidator;
import io.seata.server.store.SessionStorable;
import io.seata.server.store.StoreConfig;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GlobalSession
implements SessionLifecycle,
SessionStorable {
    private static final Logger LOGGER = LoggerFactory.getLogger(GlobalSession.class);
    private static final int MAX_GLOBAL_SESSION_SIZE = StoreConfig.getMaxGlobalSessionSize();
    private static ThreadLocal<ByteBuffer> byteBufferThreadLocal = ThreadLocal.withInitial(() -> ByteBuffer.allocate(MAX_GLOBAL_SESSION_SIZE));
    private static final int RETRY_DEAD_THRESHOLD = ConfigurationFactory.getInstance().getInt("server.retryDeadThreshold", 130000);
    private String xid;
    private long transactionId;
    private volatile GlobalStatus status;
    private String applicationId;
    private String transactionServiceGroup;
    private String transactionName;
    private int timeout;
    private long beginTime;
    private String applicationData;
    private final boolean lazyLoadBranch;
    private volatile boolean active = true;
    private List<BranchSession> branchSessions;
    private GlobalSessionLock globalSessionLock = new GlobalSessionLock();
    private Set<SessionLifecycleListener> lifecycleListeners = new HashSet<SessionLifecycleListener>();

    public boolean add(BranchSession branchSession) {
        if (null != this.branchSessions) {
            return this.branchSessions.add(branchSession);
        }
        return true;
    }

    public boolean remove(BranchSession branchSession) {
        return this.branchSessions.remove(branchSession);
    }

    public boolean canBeCommittedAsync() {
        List<BranchSession> branchSessions = this.getBranchSessions();
        for (BranchSession branchSession : branchSessions) {
            if (branchSession.canBeCommittedAsync()) continue;
            return false;
        }
        return true;
    }

    public boolean hasATBranch() {
        List<BranchSession> branchSessions = this.getBranchSessions();
        for (BranchSession branchSession : branchSessions) {
            if (branchSession.getBranchType() != BranchType.AT) continue;
            return true;
        }
        return false;
    }

    public boolean isSaga() {
        List<BranchSession> branchSessions = this.getBranchSessions();
        if (branchSessions.size() > 0) {
            return BranchType.SAGA == branchSessions.get(0).getBranchType();
        }
        return StringUtils.isNotBlank((String)this.transactionName) && this.transactionName.startsWith("$Saga_");
    }

    public boolean isTimeout() {
        return System.currentTimeMillis() - this.beginTime > (long)this.timeout;
    }

    public boolean isDeadSession() {
        return System.currentTimeMillis() - this.beginTime > (long)RETRY_DEAD_THRESHOLD;
    }

    @Override
    public void begin() throws TransactionException {
        this.status = GlobalStatus.Begin;
        this.beginTime = System.currentTimeMillis();
        this.active = true;
        for (SessionLifecycleListener lifecycleListener : this.lifecycleListeners) {
            lifecycleListener.onBegin(this);
        }
    }

    @Override
    public void changeGlobalStatus(GlobalStatus status) throws TransactionException {
        if (GlobalStatus.Rollbacking == status) {
            LockerManagerFactory.getLockManager().updateLockStatus(this.xid, LockStatus.Rollbacking);
        }
        this.status = status;
        for (SessionLifecycleListener lifecycleListener : this.lifecycleListeners) {
            lifecycleListener.onStatusChange(this, status);
        }
    }

    @Override
    public void changeBranchStatus(BranchSession branchSession, BranchStatus status) throws TransactionException {
        branchSession.setStatus(status);
        for (SessionLifecycleListener lifecycleListener : this.lifecycleListeners) {
            lifecycleListener.onBranchStatusChange(this, branchSession, status);
        }
    }

    @Override
    public boolean isActive() {
        return this.active;
    }

    @Override
    public void close() throws TransactionException {
        if (this.active) {
            for (SessionLifecycleListener lifecycleListener : this.lifecycleListeners) {
                lifecycleListener.onClose(this);
            }
        }
    }

    @Override
    public void end() throws TransactionException {
        if (this.isSuccessEnd()) {
            this.clean();
            for (SessionLifecycleListener lifecycleListener : this.lifecycleListeners) {
                lifecycleListener.onSuccessEnd(this);
            }
        } else {
            for (SessionLifecycleListener lifecycleListener : this.lifecycleListeners) {
                lifecycleListener.onFailEnd(this);
            }
        }
    }

    public boolean isSuccessEnd() {
        return this.status == GlobalStatus.Committed || this.status == GlobalStatus.Rollbacked || this.status == GlobalStatus.TimeoutRollbacked;
    }

    public void clean() throws TransactionException {
        if (!LockerManagerFactory.getLockManager().releaseGlobalSessionLock(this)) {
            throw new TransactionException("UnLock globalSession error, xid = " + this.xid);
        }
    }

    public void closeAndClean() throws TransactionException {
        this.close();
        if (this.hasATBranch()) {
            this.clean();
        }
    }

    public void addSessionLifecycleListener(SessionLifecycleListener sessionLifecycleListener) {
        this.lifecycleListeners.add(sessionLifecycleListener);
    }

    public void removeSessionLifecycleListener(SessionLifecycleListener sessionLifecycleListener) {
        this.lifecycleListeners.remove(sessionLifecycleListener);
    }

    @Override
    public void addBranch(BranchSession branchSession) throws TransactionException {
        for (SessionLifecycleListener lifecycleListener : this.lifecycleListeners) {
            lifecycleListener.onAddBranch(this, branchSession);
        }
        branchSession.setStatus(BranchStatus.Registered);
        this.add(branchSession);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void loadBranchs() {
        if (this.branchSessions == null && this.isLazyLoadBranch()) {
            GlobalSession globalSession2 = this;
            synchronized (globalSession2) {
                if (this.branchSessions == null && this.isLazyLoadBranch()) {
                    this.branchSessions = new ArrayList<BranchSession>();
                    Optional.ofNullable(SessionHolder.getRootSessionManager().findGlobalSession(this.xid, true)).ifPresent(globalSession -> this.branchSessions.addAll(globalSession.getBranchSessions()));
                }
            }
        }
    }

    @Override
    public void removeBranch(BranchSession branchSession) throws TransactionException {
        if (this.status != GlobalStatus.Committing && this.status != GlobalStatus.CommitRetrying && this.status != GlobalStatus.AsyncCommitting && !branchSession.unlock()) {
            throw new TransactionException("Unlock branch lock failed, xid = " + this.xid + ", branchId = " + branchSession.getBranchId());
        }
        for (SessionLifecycleListener lifecycleListener : this.lifecycleListeners) {
            lifecycleListener.onRemoveBranch(this, branchSession);
        }
        this.remove(branchSession);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public BranchSession getBranch(long branchId) {
        GlobalSession globalSession = this;
        synchronized (globalSession) {
            List<BranchSession> branchSessions = this.getBranchSessions();
            for (BranchSession branchSession : branchSessions) {
                if (branchSession.getBranchId() != branchId) continue;
                return branchSession;
            }
            return null;
        }
    }

    public List<BranchSession> getSortedBranches() {
        return new ArrayList<BranchSession>(this.getBranchSessions());
    }

    public List<BranchSession> getReverseSortedBranches() {
        ArrayList<BranchSession> reversed = new ArrayList<BranchSession>(this.getBranchSessions());
        Collections.reverse(reversed);
        return reversed;
    }

    public GlobalSession() {
        this.lazyLoadBranch = false;
    }

    public GlobalSession(String applicationId, String transactionServiceGroup, String transactionName, int timeout, boolean lazyLoadBranch) {
        this.transactionId = UUIDGenerator.generateUUID();
        this.status = GlobalStatus.Begin;
        this.lazyLoadBranch = lazyLoadBranch;
        if (!lazyLoadBranch) {
            this.branchSessions = new ArrayList<BranchSession>();
        }
        this.applicationId = applicationId;
        this.transactionServiceGroup = transactionServiceGroup;
        this.transactionName = transactionName;
        this.timeout = timeout;
        this.xid = XID.generateXID((long)this.transactionId);
    }

    public GlobalSession(String applicationId, String transactionServiceGroup, String transactionName, int timeout) {
        this(applicationId, transactionServiceGroup, transactionName, timeout, false);
    }

    public long getTransactionId() {
        return this.transactionId;
    }

    public void setTransactionId(long transactionId) {
        this.transactionId = transactionId;
    }

    public GlobalStatus getStatus() {
        return this.status;
    }

    public void setStatus(GlobalStatus status) {
        this.status = status;
    }

    public String getXid() {
        return this.xid;
    }

    public void setXid(String xid) {
        this.xid = xid;
    }

    public String getApplicationId() {
        return this.applicationId;
    }

    public String getTransactionServiceGroup() {
        return this.transactionServiceGroup;
    }

    public String getTransactionName() {
        return this.transactionName;
    }

    public int getTimeout() {
        return this.timeout;
    }

    public long getBeginTime() {
        return this.beginTime;
    }

    public void setBeginTime(long beginTime) {
        this.beginTime = beginTime;
    }

    public String getApplicationData() {
        return this.applicationData;
    }

    public void setApplicationData(String applicationData) {
        this.applicationData = applicationData;
    }

    public boolean isLazyLoadBranch() {
        return this.lazyLoadBranch;
    }

    public static GlobalSession createGlobalSession(String applicationId, String txServiceGroup, String txName, int timeout) {
        GlobalSession session = new GlobalSession(applicationId, txServiceGroup, txName, timeout, false);
        return session;
    }

    public void setActive(boolean active) {
        this.active = active;
    }

    @Override
    public byte[] encode() {
        byte[] applicationDataBytes;
        byte[] xidBytes;
        byte[] byTxNameBytes;
        byte[] byServiceGroupBytes;
        byte[] byApplicationIdBytes = this.applicationId != null ? this.applicationId.getBytes() : null;
        int size = this.calGlobalSessionSize(byApplicationIdBytes, byServiceGroupBytes = this.transactionServiceGroup != null ? this.transactionServiceGroup.getBytes() : null, byTxNameBytes = this.transactionName != null ? this.transactionName.getBytes() : null, xidBytes = this.xid != null ? this.xid.getBytes() : null, applicationDataBytes = this.applicationData != null ? this.applicationData.getBytes() : null);
        if (size > MAX_GLOBAL_SESSION_SIZE) {
            throw new RuntimeException("global session size exceeded, size : " + size + " maxBranchSessionSize : " + MAX_GLOBAL_SESSION_SIZE);
        }
        ByteBuffer byteBuffer = byteBufferThreadLocal.get();
        byteBuffer.clear();
        byteBuffer.putLong(this.transactionId);
        byteBuffer.putInt(this.timeout);
        if (byApplicationIdBytes != null) {
            byteBuffer.putShort((short)byApplicationIdBytes.length);
            byteBuffer.put(byApplicationIdBytes);
        } else {
            byteBuffer.putShort((short)0);
        }
        if (byServiceGroupBytes != null) {
            byteBuffer.putShort((short)byServiceGroupBytes.length);
            byteBuffer.put(byServiceGroupBytes);
        } else {
            byteBuffer.putShort((short)0);
        }
        if (byTxNameBytes != null) {
            byteBuffer.putShort((short)byTxNameBytes.length);
            byteBuffer.put(byTxNameBytes);
        } else {
            byteBuffer.putShort((short)0);
        }
        if (xidBytes != null) {
            byteBuffer.putInt(xidBytes.length);
            byteBuffer.put(xidBytes);
        } else {
            byteBuffer.putInt(0);
        }
        if (applicationDataBytes != null) {
            byteBuffer.putInt(applicationDataBytes.length);
            byteBuffer.put(applicationDataBytes);
        } else {
            byteBuffer.putInt(0);
        }
        byteBuffer.putLong(this.beginTime);
        byteBuffer.put((byte)this.status.getCode());
        byteBuffer.flip();
        byte[] result = new byte[byteBuffer.limit()];
        byteBuffer.get(result);
        return result;
    }

    private int calGlobalSessionSize(byte[] byApplicationIdBytes, byte[] byServiceGroupBytes, byte[] byTxNameBytes, byte[] xidBytes, byte[] applicationDataBytes) {
        int size = 35 + (byApplicationIdBytes == null ? 0 : byApplicationIdBytes.length) + (byServiceGroupBytes == null ? 0 : byServiceGroupBytes.length) + (byTxNameBytes == null ? 0 : byTxNameBytes.length) + (xidBytes == null ? 0 : xidBytes.length) + (applicationDataBytes == null ? 0 : applicationDataBytes.length);
        return size;
    }

    @Override
    public void decode(byte[] a) {
        int applicationDataLen;
        int xidLen;
        short txNameLen;
        short serviceGroupLen;
        this.branchSessions = new ArrayList<BranchSession>();
        ByteBuffer byteBuffer = ByteBuffer.wrap(a);
        this.transactionId = byteBuffer.getLong();
        this.timeout = byteBuffer.getInt();
        short applicationIdLen = byteBuffer.getShort();
        if (applicationIdLen > 0) {
            byte[] byApplicationId = new byte[applicationIdLen];
            byteBuffer.get(byApplicationId);
            this.applicationId = new String(byApplicationId);
        }
        if ((serviceGroupLen = byteBuffer.getShort()) > 0) {
            byte[] byServiceGroup = new byte[serviceGroupLen];
            byteBuffer.get(byServiceGroup);
            this.transactionServiceGroup = new String(byServiceGroup);
        }
        if ((txNameLen = byteBuffer.getShort()) > 0) {
            byte[] byTxName = new byte[txNameLen];
            byteBuffer.get(byTxName);
            this.transactionName = new String(byTxName);
        }
        if ((xidLen = byteBuffer.getInt()) > 0) {
            byte[] xidBytes = new byte[xidLen];
            byteBuffer.get(xidBytes);
            this.xid = new String(xidBytes);
        }
        if ((applicationDataLen = byteBuffer.getInt()) > 0) {
            byte[] applicationDataLenBytes = new byte[applicationDataLen];
            byteBuffer.get(applicationDataLenBytes);
            this.applicationData = new String(applicationDataLenBytes);
        }
        this.beginTime = byteBuffer.getLong();
        this.status = GlobalStatus.get((byte)byteBuffer.get());
    }

    public boolean hasBranch() {
        return this.getBranchSessions().size() > 0;
    }

    public void lock() throws TransactionException {
        this.globalSessionLock.lock();
    }

    public void unlock() {
        this.globalSessionLock.unlock();
    }

    public List<BranchSession> getBranchSessions() {
        this.loadBranchs();
        return this.branchSessions;
    }

    public void asyncCommit() throws TransactionException {
        this.addSessionLifecycleListener(SessionHolder.getAsyncCommittingSessionManager());
        this.setStatus(GlobalStatus.AsyncCommitting);
        SessionHolder.getAsyncCommittingSessionManager().addGlobalSession(this);
    }

    public void queueToRetryCommit() throws TransactionException {
        this.addSessionLifecycleListener(SessionHolder.getRetryCommittingSessionManager());
        this.setStatus(GlobalStatus.CommitRetrying);
        SessionHolder.getRetryCommittingSessionManager().addGlobalSession(this);
    }

    public void queueToRetryRollback() throws TransactionException {
        this.addSessionLifecycleListener(SessionHolder.getRetryRollbackingSessionManager());
        GlobalStatus currentStatus = this.getStatus();
        if (SessionStatusValidator.isTimeoutGlobalStatus(currentStatus)) {
            this.setStatus(GlobalStatus.TimeoutRollbackRetrying);
        } else {
            this.setStatus(GlobalStatus.RollbackRetrying);
        }
        SessionHolder.getRetryRollbackingSessionManager().addGlobalSession(this);
    }

    public String toString() {
        return "GlobalSession{xid='" + this.xid + '\'' + ", transactionId=" + this.transactionId + ", status=" + this.status + ", applicationId='" + this.applicationId + '\'' + ", transactionServiceGroup='" + this.transactionServiceGroup + '\'' + ", transactionName='" + this.transactionName + '\'' + ", timeout=" + this.timeout + ", beginTime=" + this.beginTime + ", applicationData='" + this.applicationData + '\'' + ", lazyLoadBranch=" + this.lazyLoadBranch + ", active=" + this.active + ", branchSessions=" + this.branchSessions + ", globalSessionLock=" + this.globalSessionLock + ", lifecycleListeners=" + this.lifecycleListeners + '}';
    }

    @FunctionalInterface
    public static interface LockCallable<V> {
        public V call() throws TransactionException;
    }

    @FunctionalInterface
    public static interface LockRunnable {
        public void run() throws TransactionException;
    }

    private static class GlobalSessionLock {
        private Lock globalSessionLock = new ReentrantLock();
        private static final int GLOBAL_SESSION_LOCK_TIME_OUT_MILLS = 2000;

        private GlobalSessionLock() {
        }

        public void lock() throws TransactionException {
            try {
                if (this.globalSessionLock.tryLock(2000L, TimeUnit.MILLISECONDS)) {
                    return;
                }
            }
            catch (InterruptedException e) {
                LOGGER.error("Interrupted error", (Throwable)e);
            }
            throw new GlobalTransactionException(TransactionExceptionCode.FailedLockGlobalTranscation, "Lock global session failed");
        }

        public void unlock() {
            this.globalSessionLock.unlock();
        }
    }
}

