/*
 * Decompiled with CFR 0.152.
 */
package io.seata.server.console.impl.redis;

import io.seata.common.exception.FrameworkErrorCode;
import io.seata.common.util.CollectionUtils;
import io.seata.common.util.StringUtils;
import io.seata.console.param.BaseParam;
import io.seata.console.result.PageResult;
import io.seata.core.model.GlobalStatus;
import io.seata.server.console.param.GlobalSessionParam;
import io.seata.server.console.service.GlobalSessionService;
import io.seata.server.console.vo.GlobalSessionVO;
import io.seata.server.session.SessionCondition;
import io.seata.server.storage.SessionConverter;
import io.seata.server.storage.redis.store.RedisTransactionStoreManager;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.boot.autoconfigure.condition.ConditionalOnExpression;
import org.springframework.context.annotation.Configuration;
import org.springframework.stereotype.Component;

@Component
@Configuration
@ConditionalOnExpression(value="#{'redis'.equals('${sessionMode}')}")
public class GlobalSessionRedisServiceImpl
implements GlobalSessionService {
    private static final Logger LOGGER = LoggerFactory.getLogger(GlobalSessionRedisServiceImpl.class);

    @Override
    public PageResult<GlobalSessionVO> query(GlobalSessionParam param) {
        ArrayList<GlobalSessionVO> result = new ArrayList<GlobalSessionVO>();
        Long total = 0L;
        if (param.getTimeStart() != null || param.getTimeEnd() != null) {
            LOGGER.debug("not supported according to time range query");
            return PageResult.failure((String)FrameworkErrorCode.ParameterRequired.getErrCode(), (String)"not supported according to time range query");
        }
        List<Object> globalSessions = new ArrayList();
        RedisTransactionStoreManager instance = RedisTransactionStoreManager.getInstance();
        PageResult.checkPage((BaseParam)param);
        if (StringUtils.isBlank((String)param.getXid()) && param.getStatus() == null) {
            total = instance.countByGlobalSessions(GlobalStatus.values());
            globalSessions = instance.findGlobalSessionByPage(param.getPageNum(), param.getPageSize(), param.isWithBranch());
        } else {
            List<Object> globalSessionsNew = new ArrayList();
            if (StringUtils.isNotBlank((String)param.getXid())) {
                SessionCondition sessionCondition = new SessionCondition();
                sessionCondition.setXid(param.getXid());
                sessionCondition.setLazyLoadBranch(!param.isWithBranch());
                globalSessions = instance.readSession(sessionCondition);
                total = globalSessions.size();
            }
            if (param.getStatus() != null && GlobalStatus.get((int)param.getStatus()) != null) {
                if (CollectionUtils.isNotEmpty(globalSessions)) {
                    globalSessionsNew = globalSessions.stream().filter(globalSession -> globalSession.getStatus().getCode() == param.getStatus().intValue()).collect(Collectors.toList());
                    total = globalSessionsNew.size();
                } else {
                    total = instance.countByGlobalSessions(new GlobalStatus[]{GlobalStatus.get((int)param.getStatus())});
                    globalSessionsNew = instance.readSessionStatusByPage(param);
                }
            }
            if (LOGGER.isDebugEnabled()) {
                if (StringUtils.isNotBlank((String)param.getApplicationId())) {
                    LOGGER.debug("not supported according to applicationId query");
                }
                if (StringUtils.isNotBlank((String)param.getTransactionName())) {
                    LOGGER.debug("not supported according to transactionName query");
                }
            }
            globalSessions = globalSessionsNew.size() > 0 ? globalSessionsNew : globalSessions;
        }
        SessionConverter.convertToGlobalSessionVo(result, globalSessions);
        return PageResult.success(result, (Integer)total.intValue(), (Integer)param.getPageNum(), (Integer)param.getPageSize());
    }
}

