/*
 * Decompiled with CFR 0.152.
 */
package io.seata.server;

import com.beust.jcommander.JCommander;
import com.beust.jcommander.Parameter;
import com.beust.jcommander.ParameterException;
import io.seata.common.util.StringUtils;
import io.seata.config.Configuration;
import io.seata.config.ConfigurationFactory;
import io.seata.server.env.ContainerHelper;

public class ParameterParser {
    private static final String PROGRAM_NAME = "sh seata-server.sh(for linux and mac) or cmd seata-server.bat(for windows)";
    private static final Configuration CONFIG = ConfigurationFactory.getInstance();
    @Parameter(names={"--help"}, help=true)
    private boolean help;
    @Parameter(names={"--host", "-h"}, description="The ip to register to registry center.", order=1)
    private String host;
    @Parameter(names={"--port", "-p"}, description="The port to listen.", order=2)
    private int port;
    @Parameter(names={"--storeMode", "-m"}, description="log store mode : file, db, redis", order=3)
    private String storeMode;
    @Parameter(names={"--serverNode", "-n"}, description="server node id, such as 1, 2, 3.it will be generated according to the snowflake by default", order=4)
    private Long serverNode;
    @Parameter(names={"--seataEnv", "-e"}, description="The name used for multi-configuration isolation.", order=5)
    private String seataEnv;
    @Parameter(names={"--sessionStoreMode", "-ssm"}, description="session log store mode : file, db, redis", order=6)
    private String sessionStoreMode;
    @Parameter(names={"--lockStoreMode", "-lsm"}, description="lock log store mode : file, db, redis", order=7)
    private String lockStoreMode;

    public ParameterParser(String ... args) {
        this.init(args);
    }

    private void init(String[] args) {
        try {
            this.getCommandParameters(args);
            this.getEnvParameters();
            if (StringUtils.isNotBlank((String)this.seataEnv)) {
                System.setProperty("seataEnv", this.seataEnv);
            }
            if (StringUtils.isBlank((String)this.storeMode)) {
                this.storeMode = CONFIG.getConfig("store.mode", "file");
            }
            if (StringUtils.isBlank((String)this.sessionStoreMode)) {
                this.sessionStoreMode = CONFIG.getConfig("store.session.mode", this.storeMode);
            }
            if (StringUtils.isBlank((String)this.lockStoreMode)) {
                this.lockStoreMode = CONFIG.getConfig("store.lock.mode", this.storeMode);
            }
        }
        catch (ParameterException e) {
            this.printError(e);
        }
    }

    private void getCommandParameters(String[] args) {
        JCommander jCommander = JCommander.newBuilder().addObject((Object)this).build();
        jCommander.parse(args);
        if (this.help) {
            jCommander.setProgramName(PROGRAM_NAME);
            jCommander.usage();
            System.exit(0);
        }
    }

    private void getEnvParameters() {
        if (StringUtils.isBlank((String)this.seataEnv)) {
            this.seataEnv = ContainerHelper.getEnv();
        }
        if (StringUtils.isBlank((String)this.host)) {
            this.host = ContainerHelper.getHost();
        }
        if (this.port == 0) {
            this.port = ContainerHelper.getPort();
        }
        if (this.serverNode == null) {
            this.serverNode = ContainerHelper.getServerNode();
        }
        if (StringUtils.isBlank((String)this.storeMode)) {
            this.storeMode = ContainerHelper.getStoreMode();
        }
        if (StringUtils.isBlank((String)this.sessionStoreMode)) {
            this.sessionStoreMode = ContainerHelper.getSessionStoreMode();
        }
        if (StringUtils.isBlank((String)this.lockStoreMode)) {
            this.lockStoreMode = ContainerHelper.getLockStoreMode();
        }
    }

    private void printError(ParameterException e) {
        System.err.println("Option error " + e.getMessage());
        e.getJCommander().setProgramName(PROGRAM_NAME);
        e.usage();
        System.exit(0);
    }

    public String getHost() {
        return this.host;
    }

    public int getPort() {
        return this.port;
    }

    public String getStoreMode() {
        return this.storeMode;
    }

    public String getLockStoreMode() {
        return StringUtils.isNotEmpty((CharSequence)this.lockStoreMode) ? this.lockStoreMode : this.storeMode;
    }

    public String getSessionStoreMode() {
        return StringUtils.isNotEmpty((CharSequence)this.sessionStoreMode) ? this.sessionStoreMode : this.storeMode;
    }

    public boolean isHelp() {
        return this.help;
    }

    public Long getServerNode() {
        return this.serverNode;
    }

    public String getSeataEnv() {
        return this.seataEnv;
    }

    public void cleanUp() {
        if (null != System.getProperty("seataEnv")) {
            System.clearProperty("seataEnv");
        }
    }
}

