/*
 * Decompiled with CFR 0.152.
 */
package io.seata.config;

import io.seata.common.exception.NotSupportYetException;
import io.seata.common.loader.EnhancedServiceLoader;
import io.seata.config.ConfigType;
import io.seata.config.Configuration;
import io.seata.config.ConfigurationProvider;
import io.seata.config.FileConfiguration;
import java.util.Objects;

public final class ConfigurationFactory {
    private static final String REGISTRY_CONF = "registry.conf";
    public static final Configuration FILE_INSTANCE = new FileConfiguration("registry.conf");
    private static final String NAME_KEY = "name";
    private static final String FILE_TYPE = "file";
    private static volatile Configuration CONFIG_INSTANCE = null;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static Configuration getInstance() {
        if (CONFIG_INSTANCE != null) return CONFIG_INSTANCE;
        Class<Configuration> clazz = Configuration.class;
        synchronized (Configuration.class) {
            if (CONFIG_INSTANCE != null) return CONFIG_INSTANCE;
            CONFIG_INSTANCE = ConfigurationFactory.buildConfiguration();
            // ** MonitorExit[var0] (shouldn't be in output)
            return CONFIG_INSTANCE;
        }
    }

    private static Configuration buildConfiguration() {
        ConfigType configType = null;
        String configTypeName = null;
        try {
            configTypeName = FILE_INSTANCE.getConfig("config.type");
            configType = ConfigType.getType(configTypeName);
        }
        catch (Exception e) {
            throw new NotSupportYetException("not support register type: " + configTypeName, (Throwable)e);
        }
        if (ConfigType.File == configType) {
            String pathDataId = "config.file.name";
            String name = FILE_INSTANCE.getConfig(pathDataId);
            return new FileConfiguration(name);
        }
        return ((ConfigurationProvider)EnhancedServiceLoader.load(ConfigurationProvider.class, (String)Objects.requireNonNull(configType).name())).provide();
    }
}

