/*
 * Decompiled with CFR 0.152.
 */
package io.scaleplan.templating;

import java.util.Objects;
import java.util.regex.Pattern;
import org.jetbrains.annotations.NotNull;

public class TemplateOptions {
    public static final Pattern DEFAULT_PATTERN = Pattern.compile("(\\{([A-Za-z0-9_:.-]*)(?:(?:\\|)([^}]*))?})");
    private final Pattern pattern;
    private final char lastDelimiter;
    private final String restKey;

    public static Builder builder() {
        return new Builder();
    }

    public Pattern getPattern() {
        return this.pattern;
    }

    public char getLastDelimiter() {
        return this.lastDelimiter;
    }

    public String getRestKey() {
        return this.restKey;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        TemplateOptions that = (TemplateOptions)o;
        return this.lastDelimiter == that.lastDelimiter && this.pattern.equals(that.pattern) && this.restKey.equals(that.restKey);
    }

    public int hashCode() {
        return Objects.hash(this.pattern, Character.valueOf(this.lastDelimiter), this.restKey);
    }

    private TemplateOptions(Builder builder) {
        this.pattern = builder.pattern;
        this.lastDelimiter = builder.lastDelimiter;
        this.restKey = builder.restKey;
    }

    static class Builder {
        private Pattern pattern = null;
        private char lastDelimiter = (char)47;
        private String restKey = "rest";

        Builder() {
        }

        public Builder setPattern(@NotNull Pattern pattern) {
            this.pattern = pattern;
            return this;
        }

        public Builder setLastDelimiter(char lastDelimiter) {
            this.lastDelimiter = lastDelimiter;
            return this;
        }

        public Builder setRestKey(String restKey) {
            this.restKey = restKey;
            return this;
        }

        public TemplateOptions build() {
            if (this.pattern == null) {
                this.pattern = DEFAULT_PATTERN;
            }
            return new TemplateOptions(this);
        }
    }
}

