/*
 * Decompiled with CFR 0.152.
 */
package io.scaleplan.templating;

import java.util.Objects;
import org.jetbrains.annotations.Nullable;

public class TemplateFragment {
    private final String value;
    private final String key;
    private final boolean hasDefault;

    public static TemplateFragment create() {
        return TemplateFragment.create(null, null);
    }

    public static TemplateFragment create(@Nullable String value) {
        return TemplateFragment.create(value, null);
    }

    public static TemplateFragment create(@Nullable String value, @Nullable String key) {
        return new TemplateFragment(value, key);
    }

    private TemplateFragment(String value, String key) {
        this.hasDefault = value != null;
        this.value = value != null ? value : "";
        this.key = key;
    }

    public String getValue() {
        return this.value;
    }

    public String getKey() {
        return this.key;
    }

    public boolean hasDefault() {
        return this.hasDefault;
    }

    public boolean isText() {
        return this.key == null;
    }

    public boolean isPlaceholder() {
        return this.key != null;
    }

    public int hashCode() {
        return Objects.hash(this.key, this.value);
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof TemplateFragment)) {
            return false;
        }
        TemplateFragment other = (TemplateFragment)obj;
        return Objects.equals(this.key, other.key) && Objects.equals(this.value, other.value);
    }

    public String toString() {
        if (this.key == null) {
            return this.value;
        }
        if (this.hasDefault) {
            return String.format("{%s|%s}", this.key, this.value);
        }
        return String.format("{%s}", this.key);
    }
}

